/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderType
 * @Package cn.freemud.enums
 * @Description: 订单类型
 * @author: liming.guo
 * @date: 2018/5/21 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.enums;

import java.util.ArrayList;
import java.util.List;

public enum OldOrderType {

    TAKE_OUT(1, "外卖"),
    PRE_ORDER(2, "预订单"),
    MALL(3, "商城"),
    COLLECT_GOODS(4, "打包带走"),
    EAT_IN(5, "店内就餐");

    private Integer code;
    private String desc;

    OldOrderType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<Integer> getAllCodes() {
        List<Integer> list = new ArrayList<>();
        for (OldOrderType type : values()) {
            list.add(type.getCode());
        }
        return list;
    }


    public static OldOrderType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OldOrderType oldOrderType : values()) {
            if (oldOrderType.getCode().equals(code)) {
                return oldOrderType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
