package cn.freemud.demoTest.service.impl;

import cn.freemud.demoTest.entities.bo.BasePaySuccessBo;
import cn.freemud.demoTest.entities.dto.OrderInfoDemoDto;
import cn.freemud.demoTest.enums.TradeBizTypeEnum;
import cn.freemud.demoTest.manager.OrderManager;
import cn.freemud.demoTest.service.AbstractPaySuccessService;
import cn.freemud.demoTest.service.AbstractTradeService;
import cn.freemud.demoTest.service.OrderService;
import cn.freemud.demoTest.service.factory.ServiceFactory;
import cn.freemud.demoTest.util.BizTypeUtil;

public class OrderServiceImpl implements OrderService {


    AbstractPaySuccessService abstractPaySuccessService;

    OrderManager orderManager;

    @Override
    public String paySuccessCallback(BasePaySuccessBo basePaySuccessBo) {

        OrderInfoDemoDto orderInfoDemoDto = orderManager.getOrderInfo();

        AbstractTradeService tradeInstance = ServiceFactory.createTradeInstance(orderInfoDemoDto.getSource());

        String result = tradeInstance.paySuccessCallback(basePaySuccessBo, orderInfoDemoDto);

        return result;
    }



}
