/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ConfirmPaymentVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: zhegnhuan.yang
 * @date: 2019/4/722 15:59
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

@Data
@ToString
public class NewPaysuccessNoticeMessage {

    /**
     * 总金额
     */
    @ApiModelProperty(value = "总金额")
    private Integer totalAmount;

    /**
     * 商家优惠金额
     */
    @ApiModelProperty(value = "商家优惠金额")
    private Integer merchantCoupon;

    /**
     * 平台优惠金额
     */
    @ApiModelProperty(value = "平台优惠金额")
    private Integer platformCoupon;

    /**
     * （ 非码交易流水号 fmID）
     */
    @ApiModelProperty(value = "非码交易流水号 fmID")
    private String transactionCode;

    /**
     * 渠道方流水号 （比如扫呗，易宝等）
     */
    @ApiModelProperty(value = "渠道方流水号 （比如扫呗，易宝等）")
    private String endTransId;

    /**
     * 第三方交易流水 （微信单号）
     */
    @ApiModelProperty(value = "第三方交易流水 （微信单号）")
    private String thirdPartTradeNo;

    /**
     * 支付商户号
     */
    @ApiModelProperty(value = "支付商户号")
    private String platformMchId;

    /**
     * 非码商户号
     */
    @ApiModelProperty(value = "非码商户号")
    private String partnerId;

    /**
     * 扫呗终端号
     */
    @ApiModelProperty(value = "扫呗终端号")
    private String appId;

    /**
     * 支付成功时间，格式：yyyyMMddHHmmss
     */
    private String tradeTime;

    /**
     * 货币类型
     */
    private String transCurrency;
    /**
     * 支付时终端交易序号
     */
    @ApiModelProperty(value = "支付时终端交易序号，订单号")
    private String transId;
    @ApiModelProperty(value = "用户openId")
    private String openId;
    /**
     * 会员规则ID
     */
    @ApiModelProperty(value = "会员规则ID")
    private String ruleId;
    /**
     * 100 是成功
     */
    @ApiModelProperty(value = "支付返回码，100是成功")
    private String resultCode;
}
