/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/10 16:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.management.thirdparty;


import com.freemud.sdk.api.assortment.order.request.order.MultiOrderRefundRequest;
import com.freemud.sdk.api.assortment.order.response.order.MultiOrderRefundResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "payment-center-application-api",url = "${saas.paymentcenter.application.api.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface MulitiPaymentClient {

    /**
     * 统一活动查询接口
     */
    @PostMapping("/payment/application/refund")
    MultiOrderRefundResponse paymentApplicationRefund(MultiOrderRefundRequest multiOrderRefundRequest, @RequestHeader("partnerId") String partnerId);

}
