package cn.freemud.entities.dto.delivery;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by freemudadmin on 2018/10/31.
 */
@Data
@ApiModel(value = "CreateDeliveryVo",description = "创建配送单请求参数")
public class CreateDeliveryVo {

    /**
     * 商品信息
     */
    @ApiModelProperty(value = "商品信息")
    @NotEmpty(message = "productInfos不能为空")
    @Valid
    private List<ProductInfo> productInfos;

    /**
     * 取餐号
     */
    @ApiModelProperty(value = "取餐号")
    @NotBlank(message = "serialNumber不能为空")
    private String serialNumber;

    /**
     * 订单编号
     */
    @ApiModelProperty(value = "订单编号")
    @NotBlank(message = "orderId不能为空")
    private String orderId;

    /**
     * 订单备注
     */
    @ApiModelProperty(value = "订单备注")
    private String orderRemark;

    /**
     * 订单来源 美团 ，饿了么，百度，口碑 等（中文）
     */
    @ApiModelProperty(value = "订单来源 美团 ，饿了么，百度，口碑 等（中文）")
    private String orderSource;

    /**
     * 订单总金额(分)
     */
    @ApiModelProperty(value = "订单总金额(分)")
    @NotNull(message = "orderTotalAmount不能为空")
    @Min(value = 1, message = "orderTotalAmount不能小于1")
    private Integer orderTotalAmount;

    /**
     * 订单实付金额(分)
     */
    @ApiModelProperty(value = "订单实付金额(分)")
    @NotNull(message = "orderActualAmount不能为空")
    @Min(value = 1, message = "orderActualAmount不能小于1")
    private Integer orderActualAmount;

    /**
     * 订单重量（kg）
     */
    @ApiModelProperty(value = "订单重量（kg）")
    private BigDecimal depatchWeight;

    /**
     * 发票抬头
     */
    @ApiModelProperty(value = "发票抬头")
    private String invoiceTitle;

    /**
     * 商户id
     */
    @ApiModelProperty(value = "商户id")
    @NotBlank(message = "partnerId不能为空")
    private String partnerId;

    /**
     * 商户信息备注
     */
    @ApiModelProperty(value = "商户信息备注")
    private String partnerRemark;

    /**
     * 订单渠道
     */
    @ApiModelProperty(value = "订单渠道")
    @NotBlank(message = "orderChannel不能为空")
    private String orderChannel;

    /**
     * 配送渠道
     */
    @ApiModelProperty(value = "配送渠道")
    private String deliveryChannel;

    /**
     * 是否预约单 ０否　１是
     */
    @ApiModelProperty(value = "是否预约单 ：０否　１是")
    @NotNull(message = "isPre不能为空")
    @Min(value = 0,message = "isPre不能小于0")
    @Max(value = 1,message = "isPre不能大于1")
    private Integer isPre;

    /**
     * 门店id(非码)
     */
    @ApiModelProperty(value = "门店id")
    @NotBlank(message = "storeId不能为空")
    private String storeId;

    /**
     * 第三方门店id
     */
    @ApiModelProperty(value = "第三方门店id")
    @NotBlank(message = "storeCode不能为空")
    private String storeCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    @NotBlank(message = "storeName不能为空")
    private String storeName;

    /**
     * 门店地址
     */
    @ApiModelProperty(value = "门店地址")
    @NotBlank(message = "storeAddress不能为空")
    private String storeAddress;

    @ApiModelProperty(value = "门店所在区")
    private String storeArea;

    @ApiModelProperty(value = "门店所在市")
    private String storeCity;

    @ApiModelProperty(value = "门店所在省")
    private String storeProvince;

    /**
     * 门店经度
     */
    @ApiModelProperty(value = "门店经度")
    @NotNull(message = "storeLng不能为空")
    private BigDecimal storeLng;

    /**
     * 门店纬度
     */
    @ApiModelProperty(value = "门店纬度")
    @NotNull(message = "storeLat不能为空")
    private BigDecimal storeLat;

    /**
     * 门店电话
     */
    @ApiModelProperty(value = "门店电话")
    @NotBlank(message = "storePhone不能为空")
    private String storePhone;

    /**
     * 门店联系人
     */
    @ApiModelProperty(value = "门店联系人")
    private String storeContact;

    /**
     * 收货人姓名
     */
    @ApiModelProperty(value = "收货人姓名")
    @NotBlank(message = "receiverName不能为空")
    private String receiverName;

    /**
     * 收货人联系方式
     */
    @ApiModelProperty(value = "收货人联系方式")
    @NotBlank(message = "receiverPrimaryPhone不能为空")
    private String receiverPrimaryPhone;

    /**
     * 收货人备用联系方式
     */
    @ApiModelProperty(value = "收货人备用联系方式")
    private String receiverSecondPhone;

    /**
     * 收货人地址
     */
    @ApiModelProperty(value = "收货人地址")
    @NotBlank(message = "receiverAddress不能为空")
    private String receiverAddress;

    /**
     * 收货人经度
     */
    @ApiModelProperty(value = "收货人经度")
    @NotNull(message = "receiverLng不能为空")
    private BigDecimal receiverLng;

    /**
     * 收货人纬度
     */
    @ApiModelProperty(value = "收货人纬度")
    @NotNull(message = "receiverLat不能为空")
    private BigDecimal receiverLat;

    /**
     * 所在城市
     */
    @ApiModelProperty(value = "所在城市")
    @NotBlank(message = "cityName不能为空")
    private String cityName;

    @ApiModelProperty(value = "所在省份")
    private String provinceName;

    @ApiModelProperty(value = "所在区")
    private String areaName;

    /**
     * 配送服务代码（飞速达:4002；快速达:4011；及时达:4012；集中送:4013）
     */
    @ApiModelProperty(value = "配送服务代码（飞速达:4002；快速达:4011；及时达:4012；集中送:4013）")
    private Integer deliveryServiceCode;

    /**
     * 商品类型 1送餐; 2送药; 3百货;4脏衣收; 5干净衣派;6生鲜; 7保单;8饮品；9现场勘查；99其他
     */
    @ApiModelProperty(value = "商品类型 1送餐; 2送药; 3百货;4脏衣收; 5干净衣派;6生鲜; 7保单;8饮品；9现场勘查；99其他")
    private Integer productType;

    @ApiModelProperty(value = "回调地址")
    @NotBlank(message = "callbackUrl不能为空")
    private String callbackUrl;

    @ApiModelProperty(value = "用户下单时间")
    @NotNull(message = "orderTime不能为空")
    private Date orderTime;

    @ApiModelProperty(value = "用户期望送达时间")
    private Date expectTime;

    @ApiModelProperty(value = "微信token 渠道为微信物流时必传")
    private String accessToken;

    @ApiModelProperty(value = "小程序openid 渠道为微信物流时必传")
    private String openId;

    @ApiModelProperty(value = "商家小程序的路径，建议为订单页面 渠道为微信物流时必传")
    private String wxaPath;

    @ApiModelProperty(value = "小程序appId 渠道为微信物流时必传")
    private String wxAppId;

    @ApiModelProperty(value = "微信物流公司id")
    private String wxCompanyId;

    @ApiModelProperty(value = "微信物流公司快递编码")
    private String wxBizId;

    @ApiModelProperty(value = "微信物流公司服务类型ID")
    private Integer serviceType;

    @ApiModelProperty(value = "微信物流公司服务类型名称")
    private String serviceName;

    @ApiModelProperty(value = "非码运单号")
    private String deliveryId;
    
    @ApiModelProperty(value = "是否大订单 ：  0-否 , 1-是")
    private Integer isLargeOrder;
    
    @ApiModelProperty(value = "是否实时送达：   0-否 , 1-是")
    private Integer isImmediateDelivery;
    
    @ApiModelProperty(value = "预计送达时间-UTC 时间")
    private String expectDeliveryTimeByUTC;
    
    @ApiModelProperty(value = "餐品总额(单位:分)")
    private Integer productTotal;
    
    @ApiModelProperty(value = "是否支付：  0-否 , 1-是 ")
    private Integer isPayed;
    
    @ApiModelProperty(value = "付款类型")
    private String tenderType;
    
    @ApiModelProperty(value = "启用新版税率规则计算开票：0-关闭，1-开启")
    private Integer taxFlag;
    
    @ApiModelProperty(value = "配送费(单位:分)")
    private Integer deliveryTotal;

    @ApiModelProperty(value = "订单显示ＩＤ(餐道专用)")
    private String displayOrderId;
    
}
