package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderTaskReq;
import com.freemud.application.sdk.api.promotioncenter.request.promotion.ActivityUpdateStockRequest;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.enums.*;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CreateFatherSonOrderRequest
 * @Package com.freemud.sdk.api.assortment.order.request.order
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/6/18 14:19
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CreateFatherSonOrderRequest extends BaseConfig {
    private OrderInfo parentOrder;
    private List<OrderInfo> orderInfoList;
    private String partnerId;
    //操作人
    private String operator;
    /**
     * 消息Queue信息
     */
    MqMessageRequest mqMessageRequest;

    /**
     * 订单渠道类型
     */
    private String menuType;

    private String openId;

    @Data
    public static class OrderInfo {
        /**
         * 默认不填=1，订单业务类型 1:普通订单 2:虚拟订单
         */
        private Integer bizType;
        private String partnerId;
        /**
         * 门店ID
         */
        private String shopId;
        /**
         * 第三方门店
         */
        private String thirdShopId;
        /**
         * 门店名称
         */
        private String shopName;
        /**
         * 用户ID
         */
        private String userId;
        /**
         * 用户名称
         */
        private String userName;
        /**
         * 用户电话
         */
        private String phone;
        /**
         * 收货地址 非必填
         */
        private String address;
        /**
         * 收货地址经度 非必填
         */
        private String longitude;
        /**
         * 收获地址维度  非必填
         */
        private String latitude;
        /**
         * 订单类型  1 外卖 2.预订单 3.商城 4 自提
         */
        private QueryOrderType orderType;
        /**
         * 订单状态
         */
        private OldOrderStatus orderStatus;
        /**
         * 支付类型
         */
        private QueryPayType payType;
        /**
         * 支付状态
         */
        private PayStatus payStatus;
        /**
         * 支付渠道号
         */
        private String payChannel;
        /**
         * 支付渠道名称
         */
        private String payChannelName;
        /**
         * 订单来源
         */
        private String source;
        /**
         * 订单来源名称
         */
        private String sourceName;
        /**
         * 期望送达时间
         */
        private Long gmtExpect;
        /**
         * 支付时间
         */
        private Date payTime;

        /**
         * 订单备注
         */
        private String remark;

        /**
         * 实付金额
         */
        private Long amount;
        //桌号
        private String barCounter;
        //订单来源 区分会员单和商品单
        private Integer orderClient;
        //是否是父订单
        private Boolean isParent;
        /**
         * 商品列表
         */
        private List<CreateOrderProductRequest> products;
        /**
         * 其他结算列表
         */
        private List<CreateOrderAccountRequest> accounts;


        public BaseCreateOrderRequest.DeliveryTypeInfo addInfo;

        /**
         * 促销活动扣减库存
         */
        public ActivityUpdateStockRequest activityUpdateStockRequest;

        //订单扩展信息 （门店渠道信息）
        private OrderExtendedReq orderExtended;

        //预订单任务
        private OrderTaskReq orderTask;

        /**
         * 微信、支付宝、APP渠道appid
         */
        private String appId;

    }
}
