package cn.freemud.service.thirdparty;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: WechatMchClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2019/3/12 14:57
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@FeignClient(name = "WECHATMCH-SERVICE", url = "${saas.wechatmchclient.feign.url}")
public interface WechatMchClient {

    /**
     * 点餐订单信息同步到微信
     */
    @PostMapping(value = "v3/catering/orders/sync-status", produces = MediaType.APPLICATION_JSON_VALUE ,consumes = MediaType.APPLICATION_JSON_VALUE )
    Object syncStatus(@RequestHeader("Authorization") String authorization, @RequestBody String syncStatusDto);
}
