/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderRelationFactoryImpl
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.coupon.impl;

import cn.freemud.service.coupon.CouponRelationFactory;
import cn.freemud.service.coupon.CouponRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CounponRelationFactoryImpl implements CouponRelationFactory {

    /**
     * coco商户
     */
    @Value("#{'${coco.partnerId}'.split(',')}")
    private List<String> cocoPartnerId;

    /**
     * coco的订单相关
     */
    @Autowired
    @Qualifier("cocoCouponRelationService")
    CouponRelationService cocoCouponRelationService;

    /**
     * 平台的订单相关
     */
    @Autowired
    @Qualifier("platformCouponRelationService")
    CouponRelationService platformCouponRelationService;

    @Override
    public CouponRelationService getVerificationCouponService(String partnerId) {
        if(cocoPartnerId.contains(partnerId)){
            return cocoCouponRelationService;
        }else{
            return platformCouponRelationService;
        }
    }
}
