package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author yuanyuan.jing  2018/12/14 18:28
 */
@Data
@ApiModel(description = "申请退款请求")
@Deprecated
public class RefundRequest extends RefundReq {
    @ApiModelProperty(value = "退款交易序号",position = 8)
    private String refundId;

    @ApiModelProperty(value = "非码交易流水号",position = 8)
    private String fmId;

    @Min(value = 0,message = "支付总金额最小是0")
    @NotNull(message = "支付总金额不能为空")
    @ApiModelProperty(value = "总金额",position = 10)
    private Integer totalAmount;

    @Min(value = 1,message = "退款金额最小是1")
    @NotNull(message = "退款金额不能为空")
    @ApiModelProperty(value = "退款金额",position = 11)
    private Integer refundAmount;

    @ApiModelProperty(value = "退款原因描述",position = 12)
    private String refundDesc;

    @ApiModelProperty(value = "退款回调地址",position = 13)
    private String notifyUrl;

    /**
     * 冗余基础信息字段
     */
    @ApiModelProperty(value = "接口版本，必须为2", position = 1)
    private String ver;

    @ApiModelProperty(value = "商户编号（由非码提供）", position = 2, required = true)
    private String partnerId;

    @ApiModelProperty(value = "商家门店号（在线支付需要提前定义）", position = 3, required = true)
    private String storeId;

    @ApiModelProperty(value = "商家POS机编号（可以使用固定值）", position = 4, required = true)
    private String stationId;

    @ApiModelProperty(value = "营业员编号（可以使用固定值）", position = 5, required = true)
    private String operatorId;

    @ApiModelProperty(value = "业务日期", position = 7)
    private String businessDate;

    @ApiModelProperty(value = "终端交易序号", position = 6, required = true)
    private String transId;

    @ApiModelProperty(value = "客户端code", position = 8, required = true)
    private Long clientCode;

    @ApiModelProperty(value = "退款时分账规则",position = 13)
    private String accountDivided;

    @ApiModelProperty(value = "退款操作人",position = 14)
    private String operatorName;
}
