/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.enums.RefundReasonEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

/**
 * 拼团失败退款
 *
 * @author shichang.wang 2021/4/15
 */
@ApiModel("拼团失败退款")
@Data
public class SpellGroupFailRefundVo {


    @NotEmpty(message = "团号不能为空")
    @ApiModelProperty("团号")
    private String spellGroupCode;


    /**
     * 取消原因
     * {@link cn.freemud.enums.RefundReasonEnum#Other}
     * {@link cn.freemud.enums.RefundReasonEnum#SPELL_GROUP_FAIL_TIME_OUT}
     * {@link cn.freemud.enums.RefundReasonEnum#SPELL_GROUP_FAIL_SPONSOR_CANCEL}
     */
    @ApiModelProperty(value = "取消原因", notes = "取消原因"+ RefundReasonEnum.SPELL_GROUP_FAIL_API_DOC)
    private Integer reason;

    /**
     * 订单号列表
     */
    @NotEmpty(message = "订单号列表 不能为空")
    @ApiModelProperty("订单号列表")
    private List<String> orderCodeList;


}
