package cn.freemud.demo.manager.product;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.demo.entities.bo.goods.ValidateShopProductRequestBO;
import cn.freemud.demo.adapter.manager.ProductBO2DTOAdapter;
import cn.freemud.demo.adapter.manager.ProductDTO2BOAdapter;
import cn.freemud.demo.entities.bo.goods.GetProductBO;
import cn.freemud.demo.entities.bo.goods.GetProductBySkuIdResponseBO;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.demo.entities.bo.goods.ValiadShopProductBO;
import cn.freemud.demo.entities.bo.product.GetProductBySkuIdBO;
import cn.freemud.demo.entities.bo.product.GetProductStock;
import cn.freemud.demo.entities.bo.product.GetRequiredProductListBO;
import cn.freemud.demo.entities.bo.product.ProductStockBO;
import cn.freemud.entities.dto.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.ItemService;
import cn.freemud.service.impl.AssortmentSdkService;
import cn.freemud.service.thirdparty.ProductClient;
import cn.freemud.service.thirdparty.StockClient;
import cn.freemud.service.thirdparty.StoreItemClient;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.application.sdk.api.productcenter.request.product.valid.ValidateShopProductRequest;
import com.freemud.application.sdk.api.productcenter.response.ProductResponseDTO;
import com.freemud.application.sdk.api.productcenter.response.valid.ValiadShopProductResponse;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("KgdProductService")
public class KgdProductServiceImpl implements ProductService {


    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private ProductDTO2BOAdapter productDTO2BOAdapter;

    @Autowired
    private ProductBO2DTOAdapter productBO2DTOAdapter;


    @Autowired
    private ItemService itemService;

    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;

    @Autowired
    private StockClient stockClient;

    @Autowired
    private StoreItemClient storeItemClient;


    @Autowired
    private ProductClient productClient;

    @Override
    public List<ProductBO> getProductInfo(GetProductBO getProductBO) {
        // 获取添加商品的详细信息

        List<GetMenuResponseDto.DataBean.RootNodeBean.ChildrenBeanFirst.ChildrenBeanSecond.ProductBean> productBeanListSpuClass = assortmentSdkService.getProductsInfo(getProductBO.getPartnerId(),
                        getProductBO.getStoreId(), getProductBO.getGoodsId(), getProductBO.getMenuType(), shoppingCartBaseService);

        List<ProductBO> productList = new ArrayList<>();
        for (GetMenuResponseDto.DataBean.RootNodeBean.ChildrenBeanFirst.ChildrenBeanSecond.ProductBean dto : productBeanListSpuClass){
            ProductBO platformProductBO = productDTO2BOAdapter.convert2ProductBO(dto);
            productList.add(platformProductBO);
        }
        return productList;
    }

    @Override
    public Map<String, GetProductBySkuIdResponseBO> getProductInfoBySkuIds(GetProductBySkuIdBO getProductBySkuIdBO) {

        Map<String, GetProductBySkuIdResponseBO> products = itemService.getProductsBySkuId(getProductBySkuIdBO.getSkuids(), getProductBySkuIdBO.getPartnerId(),
                getProductBySkuIdBO.getStoreId(), getProductBySkuIdBO.getMenuType());


        return products;
    }

    @Override
    public List<ProductStockBO> getProductStock(GetProductStock getProductStock) {

        GetProductStockRequestDto getProductStockRequestDto = productBO2DTOAdapter.convert2GetProductStockDto(getProductStock);

        GetProductStockResponseDto availableStocks = stockClient.getAvailableStocks(getProductStockRequestDto);
        if (availableStocks == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(availableStocks.getCode())) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_STOCK_NOT_HAVE);
        }
        List<ProductStockBO> list = new ArrayList<>();
        if (CollectionUtils.isEmpty(availableStocks.getResult())) {
            return list;
        }
        for (GetProductStockResponseDto.DataBean dataBean : availableStocks.getResult()){
            ProductStockBO productStockBO = productDTO2BOAdapter.convert2ProductStockBO(dataBean);
            list.add(productStockBO);
        }
        return list;

    }

    @Override
    public ValiadShopProductBO validateShopProduct(ValidateShopProductRequestBO validateShopProductRequestBO) {

        ValidateShopProductRequest validateShopProductRequest = productBO2DTOAdapter.convert2ValidateShopProductRequest(validateShopProductRequestBO);

        ProductResponseDTO<ValiadShopProductResponse> valiadProductResponse = storeItemClient.validateShopProduct(validateShopProductRequest);
        if (null == valiadProductResponse || !Objects.equals(com.freemud.application.sdk.api.productcenter.constant.ResponseConstant.SUCCESS_RESPONSE_CODE, valiadProductResponse.getErrcode())
                || valiadProductResponse.getData() == null) {
            return null;
        }
        ValiadShopProductBO valiadShopProductBO = productDTO2BOAdapter.convert2ProductStockBO(valiadProductResponse.getData());

        return valiadShopProductBO;
    }

    @Override
    public List<String> getRequiredProductList(GetRequiredProductListBO getRequiredProductListBO) {

        RequiredProductRequest request = productBO2DTOAdapter.convert2RequiredProductRequest(getRequiredProductListBO);

        ProductBaseResponse<List<String>> requiredProductList = productClient.getRequiredProductList(request);

        if (null != requiredProductList && ResponseCodeConstant.RESPONSE_SUCCESS.equals(requiredProductList.getErrcode()) &&
                !org.springframework.util.CollectionUtils.isEmpty(requiredProductList.getData())) {
                return requiredProductList.getData();
        }
        return null;
    }
}
