package cn.freemud.management.entities.dto.request.console;

import lombok.Data;

import java.util.List;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/7/22 下午4:30
 * @description :
 */
@Data
public class ExpandFieldsDTO {

    /**
     * 是 or 开启
     */
    public static String STR_TRUE = "1";

    /**
     * 否 or 关闭
     */
    public static String STR_FALSE = "0";

    /**
     * 月销量配置值
     */
    private String monthlySalesConfigValue;

    /**
     * 月销量是否展示（1-是；0-否）
     */
    private String monthlySalesShow;

    /**
     * 点赞数是否展示（1-是；0-否）
     */
    private String likesShow;

    /**
     * 点赞数配置值
     */
    private String likesConfigValue;

    /**
     * 扫桌码下单(1-开启;0-关闭) 开启该配置的门店在下单的时候，需要判断有没有桌号，如果没有桌号需要扫码获取桌号后再下单
     */
    private String scanOrderSwitch;

    // TODO 省略了 高峰时间配送时间 List<Map> 字段对接 peakTimeDelivery

    /**
     * 每增加一公里增加的时长（分钟）
     */
    private String appendMinutePerKilometer;

    /**
     * 自提打包是否收取餐具费(1-开启;0-关闭)
     */
    private String pickupPackageFeeSwitch;

    /**
     * 外卖打包是否收取餐具费(1-开启;0-关闭)
     */
    private String deliveryPackageFeeSwitch;

    /**
     * 派单模式(0-系统自动派单;1-手动派单)
     */
    private String dispatchType;

    /**
     * 手动派单的半自动配置
     */
    private List<DispatchConfig> dispatchConfig;

    /**
     * 高峰时段出餐时长配置
     */
    private List<PeakShipmentDTO> peakShipment;

}
