package cn.freemud.demo.entities.bo.goods;

import cn.freemud.demo.entities.bo.CouponCode;
import cn.freemud.demo.entities.bo.SendGoods;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.CreateOrderVo;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ShoppingCartGoodsApportionBO {

    private String sessionId;

    private String userId;

    private String partnerId;

    private String shopId;

    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;

    /**
     * 买一赠一寄件商品
     */
    private List<ChooseGood> chooseGoods;

    private ManagerServiceBO managerService;

    private CartGoods addGoods;
    /**
     * 会员卡信息
     */
    private BuyMemberCard buyMemberCard;
    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 是否为结算页
     *  1：结算页 0：点餐页
     * 结算页会查询用户优惠券，点餐页不会查询用户优惠券
     */
    private Integer flag;

    /**
     * 加价购商品
     */
    private List<SendGoods> sendGoods;

    /**
     * 活动号
     */
    private String activityCode;

    /**
     * 优惠券code列表
     */
    private List<CouponCode> couponCodes;

    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;

    /**
     * 是否使用用户积分
     * 1=不显示积分
     * 2=显示积分但不扣减
     * 3=显示积分且扣减
     */
    private Integer useCustomerScore;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;

    /**
     * 优惠券号
     */
    private String couponCode;

    private String wxappid;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    /**
     * 购物车版本号（拼单）
     */
    private Integer carVer;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    private String tableNumber;

    private PremiumExchangeActivity premiumExchangeActivity;



    @Data
    public static class PremiumExchangeActivity {
        @NotNull(message = "activityCode 不能为空")
        private String activityCode;
        @NotNull(message = "activityName 不能为空")
        private String activityName;
        /**
         * 加价购sku商品信息
         */
        @Valid
        private List<CreateOrderVo.PremiumExchangeActivity.Product> products;

        @Data
        public static class Product {
            /**
             * spuId 商品原始id
             */
            @NotNull(message = "spuId不能为空")
            private String spuId;

            /**
             * skuId 如果是多规格 skuId 不能为空
             */
            @NotNull(message = "skuId不能为空")
            private String skuId;
            /**
             * 商品名称
             */
            @NotNull(message = "商品名称不能为空")
            private String skuName;

            @NotNull(message = "商品数量不能为空")
            private Integer qty;

            /**
             * 图片
             */
            private String picture;

            /**
             * 原价 入参不需要传，做对象组装使用
             */
            private Long originalPrice;
            /**
             * 现价 入参不需要传，做对象组装使用
             */
            private Long nowPrice;

            /**
             * 商品状态 入参不需要传，做对象组装使用 （/1下架/2上架/3售罄/4删除/5上架不可售(上架状态但是不在可售时间范围)）
             */
            private Integer status;

            @Valid
            private List<CreateOrderVo.PremiumExchangeActivity.Product.Attribute> attributes;

            @Data
            public static class Attribute {
                /**
                 * 属性ID
                 */
                private String attributeId;

                /**
                 * 属性名称
                 */
                private String attributeValue;
            }
        }

    }

    @Data
    public final static class BuyMemberCard {
        /**
         * 付费会员卡ID
         */
        private String paidId;
        /**
         * 规则ID
         */
        private String ruleId;
    }
    @Data
    public static class ChooseGood {

        /**
         * 活动类型
         */
        private Integer activeType;

        /**
         * 活动号
         */
        private String activeCode;

        /**
         * 赠送商品id
         */
        private String goodsId;

        /**
         * 赠送商品数量
         */
        private Integer qty;

        /**
         * 可兑换商品券编号
         */
        private String couponCode ;

        /**
         * 商品券兑换数量
         */
        private Integer couponQty;

        /**
         *  是否已选择寄杯
         */
        private Boolean sendCoupon;
    }



}
