/*
package com.freemud.application.sdk.api.ordercenter.service;

import com.freemud.application.sdk.api.base.BaseRequest;
import com.freemud.application.sdk.api.ordercenter.constant.InterfaceAddressConstant;
import com.freemud.application.sdk.api.ordercenter.enums.ResponseResultEnum;
import com.freemud.application.sdk.api.ordercenter.request.OrderManagerRequest;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp;
import com.freemud.application.sdk.api.ordercenter.response.OrderManagerResponse;
import com.freemud.application.sdk.api.ordercenter.util.ResponseUtil;
import com.freemud.application.sdk.api.util.RequestThirdPartyUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Objects;

*/
/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderManagerSdkService
 * @Package com.freemud.application.sdk.api.ordercenter.service
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/3/27 16:18
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 *//*

@Service
public class OrderManagerSdkService {

    @Autowired
    @Qualifier("orderManagerRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private OrderManagerCenterProperties orderManagerCenterProperties;
    public static final String SUCCESS_RESPONSE_CODE = "100";

    */
/**
     * 根据综合条件查询订单
     *//*

    public BaseResponse<OrderManagerResponse> statusOperate(OrderManagerRequest request) {
        OrderBaseResp<OrderManagerResponse> responseDTO = RequestThirdPartyUtils.httpJsonReqComplexNew(restTemplate, InterfaceAddressConstant.STATUS_OPERATE,
                createBaseRequest(request, ""), new ParameterizedTypeReference<OrderBaseResp<OrderManagerResponse>>() {
                });
        return responseHandle(responseDTO);
    }

    private <T> BaseResponse<T> responseHandle(OrderBaseResp<T> responseDTO) {
        if (responseDTO == null) {
            return ResponseUtil.error(ResponseResultEnum.SYSTEM_BUSINESS_ERROR.getCode(), ResponseResultEnum.SYSTEM_BUSINESS_ERROR.getMessage());
        }
        if (!Objects.equals(SUCCESS_RESPONSE_CODE, responseDTO.getCode())) {
            return ResponseUtil.error(ResponseResultEnum.SYSTEM_BUSINESS_ERROR.getCode(), responseDTO.getMessage());
        }
        BaseResponse<T> result = new BaseResponse<>();
        result.setCode(responseDTO.getCode());
        result.setMessage(responseDTO.getMessage());
        result.setResult(responseDTO.getResult());
        result.setVer(responseDTO.getVer());
        return result;
    }
    private <T> BaseRequest<T> createBaseRequest(T req, String trackingNo) {
        BaseRequest<T> request = new BaseRequest<>();
        request.setRequestBody(req);
        request.setAppName(orderManagerCenterProperties.getAppName());
        request.setBaseUrl(orderManagerCenterProperties.getBaseUrl());
        request.setTrackingNo(trackingNo);
        return request;
    }
}
*/
