package com.freemud.application.sdk.api.ordercenter.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 微商城退款方式
 */
@Getter
public enum RefundModeEnum {

    REFUND_ALL((byte) 1, "退款退货"),
    UN_REFUND_GOODS((byte) 2, "只退款不退货"),
    ;

    private final Byte index;
    private final String name;

    RefundModeEnum(Byte index, String name) {
        this.index = index;
        this.name = name;
    }

    public static final String API_DOC = "微商城退款方式 1:退款退货 2:只退款不退货";


    private static class EnumCacheHolder {
        private static final Map<Byte, RefundModeEnum> CACHE;

        static {
            CACHE = Arrays.stream(RefundModeEnum.values()).collect(Collectors.toMap(RefundModeEnum::getIndex, v -> v));
        }
    }

    public static RefundModeEnum getByIndex(Byte index) {
        return EnumCacheHolder.CACHE.get(index);
    }
}
