/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ProductInfoResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/28 21:30
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@ApiModel(value="ProductInfoResponseVo 对象",description="productInfoResponseVo")
public class ProductInfoResponseVo {

    /**
     * amount : 3297
     * number : 3
     * products : [{"id":"109331453464019219","name":"旭洋纯豆浆","qty":1,"originalPrice":1100,"finalPrice":1099,"extra":"椰果+少冰+少糖"},{"id":"109331380529266962","name":"旭洋纯豆浆","qty":2,"originalPrice":2200,"finalPrice":2198,"extra":"椰果+常温+多糖"}]
     */

    private Long amount;

    /**
     * 原始总价
     */
    private Long originalAmount;

    private String activityName;
    /**
     * 是否有满减活动
     */
    private Boolean hasPromotionActivity;
    /**
     * 满减优惠金额
     */
    private Long buyDisCountPromotionAmount;
    /**
     * 满减优惠信息
     */
    private String buyDisCountPromotionMessage;
    /**
     * 活动类型
     */
    private Integer activityType;
    /**
     * 活动类型名称
     */
    private String activityTypeName;

    /**
     * 实际支付金额
     */
    private Long payAmount;
    /**
     * 到店取餐支付价格 单价分
     */
    private Long collectGoodsPayAmount;
    /**
     * 外卖支付价格 单价分
     */
    private Long takeOutPayAmount;
    /**
     * 不包含配送费的 外卖支付价格 商品实际价格加包装费
     */
    private Long notContainDeliveryPayAmount;
    /**
     * 是否启用外卖
     */
    private Boolean hasTakeaway;
    /**
     * 门店最低起送费
     */
    private Long deliveryLimitAmount;
    /**
     * 门店配送费
     */
    private Long deliveryAmount;
    /**
     * 外卖配送信息
     */
    private String deliveryLimitMessage;
    /**
     * 包装费
     */
    private Long packageAmount;

    /**
     * 限时折扣优惠金额
     */
    private Long discountLimitAmount;

    private Integer number;
    private List<ProductBean> products;

    @NoArgsConstructor
    @Data
    public static class ProductBean {
        /**
         * id : 109331453464019219
         * name : 旭洋纯豆浆
         * qty : 1
         * originalPrice : 1100
         * finalPrice : 1099
         * extra : 椰果+少冰+少糖
         */

        private String pid;
        private String spuId;
        private String skuId;
        private String name;
        /**
         * spu名称
         */
        private String spuName;
        private Integer qty;
        /**
         * 原始价格
         */
        private Long originalPrice;
        /**
         * 单商品原总价
         */
        private Long originalTotalPrice;
        /**
         * 单商品折扣价
         */
        private Long finalTotalPrice;
        private Long finalPrice;
        private Long packPrice;
        private String extras;
        private String cartProductId;
        private int type;
        private String picture;
        private List<ExtraBean> extra;
        private String specProductId;

        @Data
        public static class ExtraBean {

            private String productId;

            private String productName;

            private String attributeId;

            private String attributeName;

            private String groupId;

            private Integer qty;

        }

    }

    // 优惠券总数量
    private Integer couponNum;
    /**
     * 可用优惠券信息
     */
    private Integer usableCouponNum;
    private List<ActivityCouponBean> usableCoupons;

    /**
     * 不可用优惠券信息
     */
    private Integer disableCouponNum;
    private List<ActivityCouponBean>  disableCoupons;

    /*private List<DiscountActivityDto.DiscountMessage> discountProducts;*/

    /**
     * 限时特价活动信息
     */
    private List<DiscountActivity> discountActivity;
    @Data
    public static class DiscountActivity {
        private String spuId;
        private String skuId;
        private String skuName;
        /**
         * 每单限购数量
         */
        private Integer limitBuyCount;
        /**
         * 特价商品剩余可购买数量
         */
        private Integer remainStock;
    }
}
