package cn.freemud.enums;

/**
 * @author freemud
 * @title: ActivityPromptEnum
 * @projectName order-group
 * @description: TODO
 * @date 2021/8/3下午4:16
 */
public class ActivityPromptEnum {

    public enum PreferentialTypeEnum {
        TO_ORDER_ITEM_QUANTITY(3, "按订单商品件数");

        private Integer code;
        private String desc;

        PreferentialTypeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PreferentialTypeEnum getByCode(String code) {
            for (PreferentialTypeEnum type : values()) {
                if (type.getCode().equals(code)) {
                    return type;
                }
            }
            return null;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /*
        购物车
            - 空
                - - 1 : 每满 ： 满足  x 元 减 Y 元 ，最高 减 Z元
                    - -  满足 satisfy 减 deduct 最高减 maxDeduct
                - - 2 : 阶梯满减：满足 X 元 减 Y 元,
                    - -满足 satisfy 减 deduct

            - 有
                - - 满足
                    - - 3 : 满足 X 元 减 Y 元 还差 Z元
                        - - 满足 satisfy 减 deduct 还差 missing
                    - - 4 : 已减 X 元 再买 Y 元 减 Z 元
                        - - 已减 alreadyDecut 再买againBuy 减 deduct

                    - - 11 : 满足 X 件 减 Y 元 还差 Z元
                        - - 满足 satisfy 减 deduct 还差 missing
                    - - 12 : 已减 X 元 再买 Y 件 减 Z 元
                        - - 已减 alreadyDecut 再买againBuy 减 deduct

                - - 不满足
                    - - 5 : 已减 X 元
                        - - 已减 deduct
    */

    /***
     * 购物车处理促销返回活动文案枚举
     * 类型插入全部是数值，具体描述还存在遗漏
     * 上面的描述没怎么看明白，先写个枚举类。
     * 有人接手，后面查漏补缺统一掉
     */
    public enum TipTypeEnum {
        ONE(1, "每满 ： 满足  x 元 减 Y 元 ，最高 减 Z元"),
        TWO(2, "阶梯满减：满足 X 元 减 Y 元"),
        THREE(3, "满足 X 元 减 Y 元 还差 Z元"),
        FOUR(4, "已减 X 元 再买 Y 元 减 Z 元"),
        FIVE(5, "已减 X 元"),
        SEVEN(7, ""),
        EIGHT(8, ""),
        TEN(10, ""),

        ELEVEN(11, "购买in 元以上的商品可参与 满足 X 件 减 Y 元 还差 Z元"),
        TWELVE(12, "已减 X 元 再买 Y 件 减 Z 元"),
        THIRTEEN(13, "购买in 元以上的商品可参与 满足 X 件 减 Y 元 还差 Z元"),
        FOURTEEN(14, "已减 X 元 再买 Y 件 减 Z 元"),
        FIFTEEN(15, "每满 ： 每满  x 件 减 Y 元 ，最高 减 Z元"),
        SIXTEEN(16, "每满 ： 每满  x 件 减 Y 元 ，最高 减 Z元"),

        ;

        private Integer code;
        private String desc;

        TipTypeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static TipTypeEnum getByCode(String code) {
            for (TipTypeEnum type : values()) {
                if (type.getCode().equals(code)) {
                    return type;
                }
            }
            return null;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


}
