package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.BatchQueryActivityInfoRequestDto;
import cn.freemud.entities.dto.BatchQueryActivityInfoResponseDto;
import cn.freemud.entities.dto.GetAppKeyRequestDto;
import cn.freemud.entities.dto.GetAppKeyResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

//测试环境：http://115.159.65.101:8082 生产环境：https://onlinecoupon.sandload.cn
@FeignClient(name = "OPEN-STORE-ONLINE-COUPON-SERVICE",url="${saas.coupononlineclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CardBinClient {

    // TODO: 21-4-1 待合并

    /**
     * 获取密钥
     * @param requestDto
     * @return
     */
    @LogIgnoreFeign(messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE,logMessage="getAppKey")
    @PostMapping("/getAppKey")
    GetAppKeyResponseDto getAppKey(GetAppKeyRequestDto requestDto);

    /**
     * 活动信息批量查询
     * @param requestDto
     * @return
     */
    @LogIgnoreFeign(messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE,logMessage="batchQueryActivityInfo")
    @PostMapping(value = "/batchQueryActivityInfo")
    BatchQueryActivityInfoResponseDto batchQueryActivityInfo(BatchQueryActivityInfoRequestDto requestDto);


}
