/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ActivityService
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2019/1/2 14:10
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.impl;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.ActivityQueryRequestDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.enums.ActivityChannelEnum;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.CreateOrderType;
import cn.freemud.service.ActivityService;
import cn.freemud.service.CommonService;
import cn.freemud.service.thirdparty.ActivityClient;
import cn.freemud.utils.PropertyConvertUtil;
import com.freemud.sdk.api.assortment.shoppingcart.enums.BusinessTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ActivityServiceImpl implements ActivityService {

    @Autowired
    private ActivityClient activityClient;

    @Autowired
    private CommonService commonService;

    private final static String application = "isaas";

    /**
     * 统一活动查询
     *
     * @param activityQueryDto   查询活动信息
     * @param activityTypeEnum 活动类型
     * @param goodsBeanDtoList 商品列表
     * @return
     */
    @Override
    public ActivityQueryResponseDto queryActivitys(ActivityQueryDto activityQueryDto, ActivityTypeEnum activityTypeEnum,
                                                   List<ActivityQueryRequestDto.QueryGoodsBeanDto> goodsBeanDtoList) {
        // 创建请求Dto
        ActivityQueryRequestDto activityQueryRequestDto = new ActivityQueryRequestDto();
        activityQueryRequestDto.setVer("1");
        activityQueryRequestDto.setPartnerCode(activityQueryDto.getPartnerId());
        activityQueryRequestDto.setStoreId(activityQueryDto.getStoreId());
        // 添加点餐方式作为入参条件
        ActivityChannelEnum activityChannelEnum = PropertyConvertUtil.orderTypeConvert2ActivityChannel(activityQueryDto.getOrderType());
        if(!Objects.isNull(activityChannelEnum)) {
            activityQueryRequestDto.setChannel(activityChannelEnum.getCode());
        }
        activityQueryRequestDto.setUserId(activityQueryDto.getUserId());
        activityQueryRequestDto.setActivityType(activityTypeEnum == null ? null : activityTypeEnum.getCode());
        activityQueryRequestDto.setGoods(goodsBeanDtoList);
        activityQueryRequestDto.setApplication(application);
        activityQueryRequestDto.setAppId(activityQueryDto.getAppId());
        activityQueryRequestDto.setIsShowBenefit(1);
        activityQueryRequestDto.setIsShowCycles(0);
        activityQueryRequestDto.setIsShowGoods(1);
        activityQueryRequestDto.setIsShowSendCoupon(0);
        activityQueryRequestDto.setIsShowSendGoods(0);
        activityQueryRequestDto.setIsShowStore(0);
        activityQueryRequestDto.setIsShowTime(0);
        activityQueryRequestDto.setOrgIds(commonService.getOrgIds(activityQueryDto.getPartnerId(), activityQueryDto.getStoreId()));
        ActivityQueryResponseDto activityQueryResponseDto = null;
        try {
            activityQueryResponseDto = activityClient.query(activityQueryRequestDto);
        } catch (Exception ignored) {
        }
        if (activityQueryResponseDto == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(activityQueryResponseDto.getStatusCode())) {
            return null;
        }else {
            return activityQueryResponseDto;
        }
    }


    @Override
    public ActivityQueryResponseDto queryActivityByType(ActivityQueryDto activityQueryDto, List<ActivityTypeEnum> activityTypeEnums,
                                                   List<ActivityQueryRequestDto.QueryGoodsBeanDto> goodsBeanDtoList) {
        // 创建请求Dto
        ActivityQueryRequestDto activityQueryRequestDto = new ActivityQueryRequestDto();
        activityQueryRequestDto.setVer("1");
        activityQueryRequestDto.setPartnerCode(activityQueryDto.getPartnerId());
        activityQueryRequestDto.setStoreId(activityQueryDto.getStoreId());
        // 添加点餐方式作为入参条件
        ActivityChannelEnum activityChannelEnum = PropertyConvertUtil.orderTypeConvert2ActivityChannel(activityQueryDto.getOrderType());
        if(!Objects.isNull(activityChannelEnum)) {
            activityQueryRequestDto.setChannel(activityChannelEnum.getCode());
        }
        activityQueryRequestDto.setUserId(activityQueryDto.getUserId());
        List<Integer> activityTypes = activityTypeEnums.stream().map(ActivityTypeEnum::getCode).collect(Collectors.toList());
        activityQueryRequestDto.setActivityTypes(activityTypes);
        activityQueryRequestDto.setGoods(goodsBeanDtoList);
        activityQueryRequestDto.setApplication(application);
        activityQueryRequestDto.setAppId(activityQueryDto.getAppId());
        activityQueryRequestDto.setIsShowBenefit(1);
        activityQueryRequestDto.setIsShowCycles(0);
        activityQueryRequestDto.setIsShowGoods(1);
        activityQueryRequestDto.setIsShowSendCoupon(0);
        activityQueryRequestDto.setIsShowSendGoods(0);
        activityQueryRequestDto.setIsShowStore(0);
        activityQueryRequestDto.setIsShowTime(0);
        activityQueryRequestDto.setOrgIds(commonService.getOrgIds(activityQueryDto.getPartnerId(), activityQueryDto.getStoreId()));
        if (Objects.equals(activityQueryDto.getOrderType(), CreateOrderType.COLLECT_GOODS.getCode())) {
            activityQueryRequestDto.setProductChannel(BusinessTypeEnum.SAAS_PICKUP.getCode());
        } else if (Objects.equals(activityQueryDto.getOrderType(), CreateOrderType.TAKE_OUT.getCode())) {
            activityQueryRequestDto.setProductChannel(BusinessTypeEnum.SAAS_DELIVERY.getCode());
        } else if (Objects.equals(activityQueryDto.getOrderType(), CreateOrderType.SAASMALL.getCode())) {
            activityQueryRequestDto.setProductChannel(BusinessTypeEnum.SAAS_MALL.getCode());
        }
        ActivityQueryResponseDto activityQueryResponseDto = null;
        try {
            activityQueryResponseDto = activityClient.query(activityQueryRequestDto);
        } catch (Exception ignored) {
        }
        if (activityQueryResponseDto == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(activityQueryResponseDto.getStatusCode())) {
            return null;
        }else {
            return activityQueryResponseDto;
        }
    }
}
