package com.freemud.sdk.api.assortment.order.request.order;


import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.enums.*;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: AssortmentGroupOrderAffirmRequest
 * @Description: 简单描述下这个类是做什么用的
 * @author: qin.zhou
 * @date: 2019/9/321:14
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class AssortmentGroupOrderAffirmRequest extends BaseConfig {

    /**
     * 商户ID 必填
     */
    private String companyId;
    /**
     * 商户名称
     */
    private String companyName;
    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 门店全局唯一编号
     */
    private String shopCode;
    /**
     * 门店名称
     */
    private String shopName;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;

    /**
     * 三方订单号
     */
    private String thirdOrderCode;
    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型  1 外卖 2.预订单 3.商城 4 自提
     */
//    private QueryOrderType orderType;
    /**
     * 订单状态
     */
//    private OldOrderStatus orderStatus;
    /**
     * 订单渠道
     */
    private Integer orderClient;
    /**
     * 订单备注
     */
    private String remark;
    /**
     * 桌号
     */
    private String barCounter;
    /**
     * 是否开具发票
     */
    private Boolean needInvoice;
    /**
     * 扩展字段
     */
    private String extInfo;
    /**
     * 就餐人数
     */
    private Integer dinersNumber;
    /**
     * 订单原始金额，单位分
     */
    private Long originalAmount;

    /**
     * 支付渠道
     */

    private String payChannel;

    /**
     * 支付渠道名称
     */
    private String payChannelName;
    /**
     *当前支付请求号
     */
    private String payRequestNo;
    /**
     * 支付时间
     */
    private String payTime;

    /**
     * 支付类型 1:线上支付 2:线下支付
     */
    private Integer payType;

    /**
     *  pos编号
     */
    private String posCode;
    /**
     * 实际支付现金金额，扣除支付自生优惠，单位分
     */
    private Long actualPayAmount;

    /**
     * 用户在界面上看到的支付金额
     */
    private Long settlementAmount;
    /**
     * 商品列表
     */
    private List<CreateOrderProductRequest> products;
    /**
     * 其他结算列表
     */
    private List<CreateOrderAccountRequest> accounts;
    
    /**
     * 手机号
     */
    private String mobile;
    //操作人
    private String operator;

}
