/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PaymentClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 支付服务
 * @author: liming.guo
 * @date: 2018/5/12519:24
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.PaySuccessBuridPointDto;
import cn.freemud.entities.dto.pay.CombPayResponse;
import com.freemud.sdk.api.assortment.order.request.payment.CombPayRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;


@FeignClient(name = "favorite",url="${saas.favorite.submit.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface BuriedPointClient {

    /**
     * 支付成功埋点
     */
    @PostMapping("/favorite/submit")
    Integer returnSubmit(@RequestBody PaySuccessBuridPointDto paySuccessBuridPointDto);
}
