/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.shoppingCart.impl;

import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.shoppingCart.ShoppingCartRelationService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("cocoShoppingCartRelationService")
public class CocoShoppingCartRelationServiceImpl implements ShoppingCartRelationService {


    @Override
    public void buildShoppingCartGoodsResponse(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo,
                                               CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult) {

        if(discountResult != null){

            List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Discount> discounts = new ArrayList<>();

            // coco返回的活动中剔除集点活动
            if(discountResult.getDiscounts() != null && !discountResult.getDiscounts().isEmpty()){
                discountResult.getDiscounts().forEach(discount -> {
                    if(ActivityTypeEnum.TYPE_221.equals(discount.getType())){
                        return;
                    }
                    discounts.add(discount);
                });
            }

            shoppingCartGoodsResponseVo.setDiscounts(discounts);
            shoppingCartGoodsResponseVo.setGoods(discountResult.getGoods());
        }

    }
}
