package cn.freemud.controller;

import cn.freemud.OrderApplication;
import cn.freemud.entities.vo.*;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderControllerTest
 * @Package cn.freemud.controller
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/22 17:44
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = OrderApplication.class)
public class OrderControllerTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    /**
     * 创建订单
     */
    @Test
    public void createOrder() {
        CreateOrderVo request = new CreateOrderVo();
        request.setSessionId("81624461b7f3991d749f6a29c888c6b3c324156d");
        request.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        request.setShopId("1036");
        request.setOrderType(1);
//        request.setTakeMealTime("12:00");
        request.setTakeOut(0);
        request.setOrderRemark("不加香菜");
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 订单支付成功后通知
     */
    @Test
    public void paySuccessCallback() {
        PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
        message.setResult_code(100);
        message.setOut_trade_no("ZHL1439O1338536503");
        message.setTrans_id("87787519950717215");
        message.setTotal_fee(1);
        message.setOpenid("ob0iP4gZeV0jWtRWxRmGtBuE0M9k");
        message.setPlatform_coupon(0);
        message.setMerchant_coupon(0);
        String str = JSONObject.toJSONString(message);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 查询订单列表
     */
    @Test
    public void queryOrders() {
        QueryOrderVo request = new QueryOrderVo();
        request.setSessionId("81624461b7f3991d749f6a29c888c6b3c324156d");
        request.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        request.setOid("1036");
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取订单详情
     */
    @Test
    public void queryOrderById() {
        QueryOrderVo request = new QueryOrderVo();
        request.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 取消支付删除订单
     */
    @Test
    public void deleteOrder() {
        DeleteOrderVo request = new DeleteOrderVo();
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 取消订单
     */
    @Test
    public void cancelOrder() {
        CancelOrderVo request = new CancelOrderVo();
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 用户退款
     */
    @Test
    public void refund() {
        OrderRefundVo request = new OrderRefundVo();
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 退款回调
     */
    @Test
    public void refundNotifyCallback() {
        RefundNotifyCallbackRequestVo request = new RefundNotifyCallbackRequestVo();
        request.setRefundStatus(100);
        request.setTransId("null");
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/order/refundNotifyCallback").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("500"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 再来一单
     */
    @Test
    public void copyOrder() {
        CopyOrderVo request = new CopyOrderVo();
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
