package cn.freemud.client;

import cn.freemud.entities.dto.SendShortMessageCodeDto;
import cn.freemud.entities.dto.SendSmsCodeResponseDto;
import cn.freemud.service.thirdparty.ShortMessageClient;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ShortMessageClientTest
 * @Package cn.freemud.client
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/25 15:21
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShortMessageClientTest {
    @Autowired
    private ShortMessageClient shortMessageClient;

    /**
     * 发送短信验证码
     */
    @Test
    public void sendSmsCode(){
        SendShortMessageCodeDto sendShortMessageCodeDto=new SendShortMessageCodeDto();
        sendShortMessageCodeDto.setMobile("15170070314");
        sendShortMessageCodeDto.setSmstype(1);
        sendShortMessageCodeDto.setContent("内容");
        sendShortMessageCodeDto.setValidcode("562345");
        sendShortMessageCodeDto.setSmschannel("1001");
        sendShortMessageCodeDto.setTemplatecode("SMS_60345418");
        SendSmsCodeResponseDto sendSmsCodeResponseDto = shortMessageClient.sendSmsCode("",sendShortMessageCodeDto);
        System.out.println("sendSmsCodeResponseDto====" + sendSmsCodeResponseDto);
    }
}
