package cn.freemud.demo.entities.bo.promotion;

import cn.freemud.demo.entities.bo.goods.TimesBeanBO;
import cn.freemud.demo.entities.bo.goods.BenefitBeanBO;
import cn.freemud.demo.entities.bo.goods.GoodsBeanBO;
import lombok.Data;

import java.util.List;

@Data
public class ActivityBO {

    /**
     * B端活动券code v1.5.4新增
     */
    private String code;
    /**
     * 活动号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动描述
     */
    private String activityDesc;
    /**
     * 活动开始时间
     */
    private Long startTime;
    /**
     * 活动结束时间
     */
    private Long endTime;
    /**
     * 库存
     */
    private Integer totalTimes;
    /**
     * 优惠可使用次数（0无限制，如果活动类型为优惠券，则为每个人该活动可以领取次数）
     */
    private Integer discountTimes;
    /**
     * 活动类型：
     * 1-整单满减
     * 11-每满减
     * 12-阶梯满减
     * 2-单品特价
     * 21-单品折扣
     * 3-优惠券
     * 5-整单满金额折
     * 51-每满金额折
     * 52-阶梯满金额折
     * 53-第M件/杯N折
     * 6-买M赠N
     * 7-满额赠券
     * 8-满N件换购
     * 81-满额换购
     * 82-阶梯满数量打折
     * 83-整单满数量打折
     */
    private Integer activityType;
    /**
     * 活动子类型 1 阶梯  2 每满
     */
    private Integer activitySubType;
    /**
     * 适用于优惠券活动，优惠券类型，0：满减券  1：代金券
     */
    private Integer couponType;
    /**
     * 商户号
     */
    private String partnerCode;
    /**
     * 优先级 默认传0
     */
    private Integer priority;
    /**
     * 审核状态，0：未审核 1：审核通过 2：审核不通过
     */
    private Integer auditStatus;
    /**
     * 活动状态，0：未启用 1：已启用 2：作废
     */
    private Integer activityStatus;
    /**
     * 券有效期开始时间
     */
    private Long validityPeriodStart;
    /**
     * 券有效期结束时间
     */
    private Long validityPeriodEnd;
    /**
     * 有效期
     */
    private Integer validityPeriod;
    /**
     * 有效期单位，s：秒、m：分、H：时、D：天，W：周、M：月、Y：年、CURRENT_DAY：领取当天
     */
    private String unit;
    /**
     * 延期时间
     */
    private Integer delayTimes;
    /**
     * 换购、满赠类型的活动可选赠品最小数量
     */
    private Integer minNum;
    /**
     * 换购、满赠类型的活动可选赠品最大数量
     */
    private Integer maxNum;
    /**
     * 最大优惠金额
     */
    private Long maxMoney;
    /**
     * 延期单位，s：秒、m：分、H：时、D：天，W：周、M：月、Y：年、CURRENT_DAY：领取当天
     */
    private String delayUnit;
    /**
     * 是否同享  0-不共享 1-共享
     */
    private Integer isShared;

    private String createTime;

    private String updateTime;

    private String creater;

    private String updateor;

    /**
     * 优惠列表（单品促销不需要此字段，传入此字段则不允许保存。）
     */
    private List<BenefitBeanBO> benefits;
    private List<GoodsBeanBO> goods;
    private List<TimesBeanBO> times;

}
