package com.freemud.sdk.api.assortment.order.response.order;

import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderOperationHistoryResp;
import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 订单状态监控信息
 *
 * @version: 1.0
 * @Description: TODO
 * @author: WangShiChang
 * @date: 2021/5/13 下午4:36
 * @Copyright: www.freemud.cn Inc.
 */
@Data
public class OrderStateInfoResp implements Serializable {
    private static final long serialVersionUID = 2840452799139432761L;

    private Integer errcode;

    private String errmsg;

    private OrderStateInfo data;

    @Data
    public static class OrderStateInfo {
        /**
         * 订单编号
         */
        private String orderCode;

        /**
         * 订单状态
         * 基础服务状态，未转换
         */
        private Integer orderState;

        /**
         * 售后单状态
         */
        private Integer afterSalesState;

        /**
         * 支付状态
         */
        private Integer payState;

        /**
         * 订单操作历史
         */
        private List<OrderOperationHistoryResp> orderOperationHistoryList;


        /**
         * 状态更新时间戳
         */
        private Long stateUpdateTimestamp;


        /**
         * 状态超时时间 单位:秒
         */
        private Long stateTimeout;


        public Long getStateUpdateTimestamp() {
            return Objects.isNull(stateUpdateTimestamp) ? 0 : stateUpdateTimestamp;
        }

        public Long getStateTimeout() {
            return Objects.isNull(stateTimeout) ? 0 : stateTimeout;
        }

        private List<OrderOperationHistoryResp> getOrderOperationHistoryList() {
            return Objects.isNull(this.orderOperationHistoryList) ? Collections.emptyList() : orderOperationHistoryList;
        }


        private boolean hasAfterSales() {
            return Objects.isNull(afterSalesState) || Objects.equals(afterSalesState, 0);
        }

    }


}
