/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: NearStoreRequestDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/11 18:50
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;

@Data
public class NearStoreRequestDto {

    //商户编号
    private String partnerId;
    //纬度
    private String latitude;
    //经度
    private String longitude;
    //关键字查询（目前匹配门店名称、地址、标签等）
    private String keyWords;
    //距离（单位：km），不传默认查5公里以内
    private String distance;
    //是否有效（0无效，1有效），不传默认有效
    private String activeFlag;
    //类型（1总公司 2公司3门店），不传默认为3
    private String typeFlag;
    //是否开通下单平台{1.是；2.否} 不传默认1
    private String placeOrderFlag;
    //是否开通delivery{1.是；2.否}  不传查询全部
    private String delivery;
    //城市，不传默认所有
    private String city;
    //页码，不传默认为1
    private Integer pageNo;
    //每页显示条数，不传默认为10
    private Integer pageSize;

}
