package cn.freemud.fuyou.service.processor;

import cn.freemud.base.constant.Version;
import cn.freemud.enums.PayChannelEnum;
import cn.freemud.fuyou.controller.request.DiscountRequest;
import cn.freemud.fuyou.service.PaymentService;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.constant.FMStatusCode;
import com.freemud.application.sdk.api.couponcenter.offline.domain.ProductRedeemVO;
import com.freemud.application.sdk.api.couponcenter.offline.domain.TransactionVO;
import com.freemud.application.sdk.api.couponcenter.offline.request.CouponRequest;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import com.freemud.application.sdk.api.couponcenter.offline.service.OfflineCouponSdkService;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.enums.OrderSettlementType;
import com.freemud.application.sdk.api.ordercenter.request.OrderSettlementReq;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderItemCreateReq;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import static cn.freemud.management.util.ResponseCodeEnum.SUCCESS;

/**
 * 优惠券
 */
@Component
public class CouponEventProcessor extends AbstractProcessor {


    private final OfflineCouponSdkService offlineCouponSdkService;

    protected CouponEventProcessor(OrderSdkService orderSdkService, PaymentService paymentService, OfflineCouponSdkService offlineCouponSdkService) {
        super(orderSdkService, paymentService);
        this.offlineCouponSdkService = offlineCouponSdkService;
    }


    @Override
    com.freemud.application.sdk.api.ordercenter.response.BaseResponse doProcess(DiscountRequest request) {
        com.freemud.application.sdk.api.ordercenter.response.BaseResponse baseResponse = new com.freemud.application.sdk.api.ordercenter.response.BaseResponse();
        baseResponse.setCode(SUCCESS.code);
        OrderInfoReqs orderInfoReqs = getOrder(request.getOrderCode());
        //1.核销券
        CouponRequest couponCodeVerificationDto = new CouponRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqtype(71);
        couponCodeVerificationDto.setPartnerId(Integer.parseInt(orderInfoReqs.getPartnerId()));
        //自取：pickup，外送：delivery，麦咖啡微信小程序：mocoffee_wx，麦咖啡支付宝小程序：mocoffee_zfb
        couponCodeVerificationDto.setChannel("pickup");
        couponCodeVerificationDto.setStation_id(request.getPosId());
        couponCodeVerificationDto.setOperator_id("-1");
        couponCodeVerificationDto.setStore_id(orderInfoReqs.getStoreId());
        //核销不需要核销通知
        //couponCodeVerificationDto.setAppFlag("kgd.N");
        // 订单号 替换成唯一序号
        couponCodeVerificationDto.setTrans_id(orderInfoReqs.getOrderCode());
        couponCodeVerificationDto.setBusiness_date(cn.freemud.base.util.DateUtil.convert2Str(new Date(), cn.freemud.base.util.DateUtil.FORMAT_yyyyMMdd));
        List<TransactionVO> transactions = new ArrayList<>();
        TransactionVO couponCodeVerificationTransDto = new TransactionVO();
        couponCodeVerificationTransDto.setCode(request.getCoupon());
        couponCodeVerificationTransDto.setTotalAmount(request.getPayAmount());
        List<ProductRedeemVO> productRedeemVOS = convertOrderItemCreateReq(request.getOrderItemList());
        couponCodeVerificationTransDto.setProducts(productRedeemVOS);
        transactions.add(couponCodeVerificationTransDto);
        couponCodeVerificationDto.setTransactions(transactions);
        final BaseResponse<CouponRedeemResponse> couponRedeemResponseBaseResponse = offlineCouponSdkService.couponRedeem(couponCodeVerificationDto, LogThreadLocal.getTrackingNo());
        if (ObjectUtils.notEqual(FMStatusCode.SUCCESS.getCode(), couponRedeemResponseBaseResponse.getCode())) {
            baseResponse.setCode(couponRedeemResponseBaseResponse.getCode());
            baseResponse.setMessage(couponRedeemResponseBaseResponse.getMessage());
        }
        return baseResponse;
    }

    private List<ProductRedeemVO> convertOrderItemCreateReq(List<OrderItemCreateReq> orderItemList) {
        List<ProductRedeemVO> products = new ArrayList<>();
        if (CollectionUtils.isEmpty(orderItemList)) {
            return products;
        }
        for (int i = 0; i < orderItemList.size(); i++) {
            //商品券核销核销参数
            ProductRedeemVO couponCodeVerificationProductDto = new ProductRedeemVO();
            couponCodeVerificationProductDto.setPid(UUID.randomUUID().toString());
            couponCodeVerificationProductDto.setConsume_num(orderItemList.get(i).getProductQuantity());
            couponCodeVerificationProductDto.setSeq(i);
            // couponCodeVerificationProductDto.setMerchantProductId(orderItemList.get(i).getProductId());
            products.add(couponCodeVerificationProductDto);
        }
        return products;
    }


    @Override
    OrderSettlementReq getOrderSettlement(DiscountRequest request) {
        OrderInfoReqs orderInfoReqs = getOrder(request.getOrderCode());
        return buildOrderSettlement("富有优惠券", OrderSettlementType.COUPON, false, orderInfoReqs, request);
    }

    @Override
    public Integer getEvent() {
        return PayChannelEnum.COUPON.getCode();
    }
}
