package cn.freemud.entities.dto;

import com.freemud.sdk.api.assortment.order.request.order.ProductBindingCouponType;
import lombok.Builder;
import lombok.Data;

import java.util.List;

@Data
@Builder
public class OrderProductAddInfo {

    /**
     * 属性名称 多糖/冷/常温
     */
    private String attributeNames;

    private String attributeForeignName;
    /**
     * 活动商品集合
     */
    private ActivityProduct activityProduct;

    /**
     * 商品绑定的券活动（买券虚拟订单才有）
     */
    private List<ProductBindingCouponType> productBindingCoupons;

    @Data
    @Builder
    public static class ActivityProduct {

        private String spuId;

        private String skuId;

        private int qty;

        private String activityId;

    }


}
