package cn.freemud.service;

import cn.freemud.entities.vo.CartGoods;
import cn.freemud.service.impl.AssortmentSdkService;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: AssortmentSdkServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: yuhao.chi
 * @date: 2019/4/20 16:47
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class AssortmentSdkServiceTest {

    @Autowired
    private AssortmentSdkService assortmentSdkService;
    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;
    @Test
    public void setShoppingCart() {
        CartGoods cartGoods =  new CartGoods();
        cartGoods.setCartGoodsUid("68a6e4f3-20c5-40b7-8906-dcee172ad9f9");
        cartGoods.setCategoryName("限时特价");
        cartGoods.setCreateTimeMili(1555733257670L);
        cartGoods.setExtra(new ArrayList<>());
        cartGoods.setGoodsId("139406561164565517");
        cartGoods.setGoodsType(1);
        cartGoods.setName("奶糖包特价");
        cartGoods.setNodeId("XSZK");
        cartGoods.setOriginalPrice(500L);
        cartGoods.setPackPrice(50L);
        cartGoods.setPic("https://picture.sandload.cn/1555732555878.png");
        cartGoods.setQty(1);
        cartGoods.setSkuId("");
        cartGoods.setSpecProductId("");
        cartGoods.setSpuId("139406561164565517");
        cartGoods.setSpuName("奶糖包特价");
        cartGoods.setSubName("");
        List<CartGoods> cartGoodsList = new ArrayList<>();
        cartGoodsList.add(cartGoods);
        String partnerId = "1864";
        String storeId = "1000189";
        String useId = "115547751030883080";

        List<CartGoods> result = assortmentSdkService.setShoppingCart(partnerId, storeId, useId, cartGoodsList,"","",shoppingCartBaseService);
        System.out.println(JSONObject.toJSONString(result));
    }

    @Test
    public void getShoppingCart() {
        String partnerId = "1864";
        String storeId = "1000189";
        String useId = "115547751030883080";

        List<CartGoods> result = assortmentSdkService.getShoppingCart(partnerId, storeId, useId,"","",shoppingCartBaseService);
        System.out.println(JSONObject.toJSONString(result));
    }

    @Test
    public void test() {
        String s = "{\"cartGoodsUid\":\"21017e5a-9d5c-4191-8fb9-3d98e6e7dc31\",\"categoryName\":\"限时特价\",\"createTimeMili\":1555759193682,\"extra\":[],\"goodsId\":\"139406561164565517\",\"goodsType\":1,\"name\":\"奶糖包特价\",\"nodeId\":\"XSZK\",\"originalPrice\":500,\"packPrice\":50,\"pic\":\"https://picture.sandload.cn/1555732555878.png\",\"qty\":2,\"skuId\":\"\",\"specProductId\":\"\",\"spuId\":\"139406561164565517\",\"spuName\":\"奶糖包特价\",\"subName\":\"\"}";
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods result = null;
        try {
            result = JSONObject.parseObject(s, new TypeReference<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods>(){});
        } catch (Exception e) {
            System.out.println(1);
        }
        System.out.println(result);
    }

}
