package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

@Data
public class BatchUpdateGoodsQtyRequestVo extends BaseRequestVo{

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @NotEmpty(message = "appId不能为空")
    private String appId;


    private String version;
    /**
     * 购物车版本号（围餐、拼单）
     */
    private Integer carVer;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    private List<GoodsQtyInfo> qtyInfoList;

}
