package cn.freemud.service.universal.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.bo.CreateOrderBo;
import cn.freemud.entities.dto.order.CreatePrepayRequestDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.CreateOrderSaasVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.universal.UniversalOrderService;
import cn.freemud.utils.ResponseUtil;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.stereotype.Service;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Service
public class SaasOrderService extends UniversalOrderService {

    @Override
    public void handleCustomParam(CreatePrepayRequestDto requestDto, Map<String, Object> customParam) {

    }

    @Override
    public CreateOrderBo getCreateOrderBo(CreateOrderBaseVo createOrderBaseVo, AssortmentCustomerInfoVo userLoginInfoDto) {
        return null;
    }

    @Override
    public void validParam(CreateOrderBaseVo createOrderBaseVo) {
        CreateOrderSaasVo createOrderSaasVo = (CreateOrderSaasVo) createOrderBaseVo;
        HibernateValidatorConfiguration configuration = Validation.byProvider(HibernateValidator.class)
                .configure()
                .failFast(false);
        ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
        Set<ConstraintViolation<CreateOrderBaseVo>> set = validatorFactory.getValidator().validate(createOrderSaasVo);
        if(CollectionUtils.isNotEmpty(set)) {
            Iterator<ConstraintViolation<CreateOrderBaseVo>> iterator = set.iterator();
            if (iterator.hasNext()) {
                ConstraintViolation<CreateOrderBaseVo> constraintViolation = iterator.next();
                throw new ServiceException(ResponseResult.PARAMETER_MISSING, constraintViolation.getMessage());
            }
        }
    }

    @Override
    public BaseResponse createSharedOrder(CreateOrderBaseVo createOrderBaseVo, StoreResponse.BizVO storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto, AssortmentCustomerInfoVo userLoginInfoDto) {
        return null;
    }

    @Override
    public BaseResponse createSharedOrder(CreateOrderBaseVo createOrderBaseVo, StoreResponse.BizVO storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto, AssortmentCustomerInfoVo userLoginInfoDto, Map<String, Object> customParam) {
        return null;
    }

    @Override
    public Map<String, Object> getCustomParam(CreateOrderBaseVo createOrderBaseVo, AssortmentCustomerInfoVo userLoginInfoDto, StoreResponse.BizVO storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto) {

        return null;
    }

    @Override
    public void customCheck(Map<String, Object> customParam) {

    }

    @Override
    public ShoppingCartGoodsDto checkShoppingCartGoods(CreateOrderBaseVo createOrderBaseVo, ShoppingCartGoodsDto shoppingCartGoodsDto) {
        return null;
    }
}
