package cn.freemud.service.universal.factory;

import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.CreateOrderSaasVo;
import cn.freemud.enums.CreateOrderSceneEnum;
import cn.freemud.service.universal.UniversalOrderService;
import cn.freemud.service.universal.impl.SaasOrderService;
import com.alibaba.fastjson.JSON;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class CreateOrderServiceFactory {

    @Autowired
    private ApplicationContext applicationContext;

    public CreateOrderSceneEnum getCreateOrderScene(Map<String, Object> param, AssortmentCustomerInfoVo assortmentCustomerInfoVo) {
        return CreateOrderSceneEnum.SAAS;
    }

    public CreateOrderBaseVo getCreateOrderVo(Map<String, Object> param, CreateOrderSceneEnum createOrderSceneEnum) {
        switch (createOrderSceneEnum) {
            case SAAS:
                return JSON.parseObject(JSON.toJSONString(param), CreateOrderSaasVo.class);
            default:
                return JSON.parseObject(JSON.toJSONString(param), CreateOrderSaasVo.class);
        }
    }

    public UniversalOrderService getCreateOrderService(CreateOrderSceneEnum createOrderSceneEnum) {
        switch (createOrderSceneEnum) {
            case SAAS:
                return applicationContext.getBean("SaasOrderService", SaasOrderService.class);
            default:
                return applicationContext.getBean("SaasOrderService", SaasOrderService.class);
        }
    }
}
