package cn.freemud.service.universal;

import cn.freemud.adapter.CreateOrderAdapter;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.util.DateUtil;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.bo.CreateOrderBo;
import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.dto.order.CreateOrderOperateDto;
import cn.freemud.entities.dto.order.CreatePrepayRequestDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.PaySuccessSource;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.manager.MemberPropertyManager;
import cn.freemud.manager.StoreInfoManager;
import cn.freemud.service.OrderAdapterService;
import cn.freemud.service.adapter.OrderCheckAdapter;
import cn.freemud.utils.ResponseUtil;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.membercenter.request.StatisticalPropertyRequest;
import com.freemud.application.sdk.api.membercenter.response.GetSvcInfoByMemberIdResponse;
import com.freemud.application.sdk.api.membercenter.service.MemberPropertyService;
import com.freemud.application.sdk.api.ordercenter.enums.PayChannelType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.sdk.api.assortment.order.request.order.PaymentRequest;
import com.freemud.sdk.api.assortment.order.response.payment.OrderPayResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import java.util.*;

/**
 * 订单服务
 *
 * @author liming.guo
 * @date 2018/05/08
 */
public abstract class UniversalOrderService {

    @Autowired
    private MemberPropertyManager memberPropertyManager;

    @Autowired
    private StoreInfoManager storeInfoManager;

    @Autowired
    private CreateOrderAdapter createOrderAdapter;

    @Autowired
    private OrderAdapterService orderAdapterService;

    /**
     * 创建订单
     */
    public final BaseResponse createOrder(CreateOrderBaseVo createOrderBaseVo, AssortmentCustomerInfoVo userLoginInfoDto) {
        String trackingNo = LogThreadLocal.getTrackingNo();
        validParam(createOrderBaseVo);
        CreateOrderBo createOrderBo = getCreateOrderBo(createOrderBaseVo, userLoginInfoDto, trackingNo);

        checkCreateOrderParam(createOrderBo, trackingNo);

        OrderExtInfoDto extInfo = getExtInfo(createOrderBo);
        //1.9.2套餐需求同步优化创建订单代码
        BaseResponse createOrderOperateDtoResponse = this.createSharedOrder(createOrderBo);
        if (createOrderOperateDtoResponse == null || !ResponseResult.SUCCESS.getCode().equals(createOrderOperateDtoResponse.getCode()) || createOrderOperateDtoResponse.getResult() == null) {
            return createOrderOperateDtoResponse;
        }
        CreateOrderOperateDto createOrderOperateDto = (CreateOrderOperateDto) createOrderOperateDtoResponse.getResult();
        //创建支付
        CreatePrepayRequestDto createPrepayRequestDto = createOrderAdapter.convertToCreatePrepayRequestDto(userLoginInfoDto, createOrderBaseVo, createOrderOperateDto, extInfo);

        return createPrepayOrder(createPrepayRequestDto);
    }

    public void checkCreateOrderParam(CreateOrderBo createOrderBo, String trackingNo) {
        checkUniversalCreateOrderParam(createOrderBo, trackingNo);
        checkCustomCreateOrderParam(createOrderBo);
    }

    public void checkUniversalCreateOrderParam(CreateOrderBo createOrderBo, String trackingNo) {

        //校验会员svc卡信息
        checkCardCode(createOrderBo.getCreateOrderBaseVo(), createOrderBo.getUserLoginInfoDto());
        // 查询购物车（内部校验券点餐方式，券是否可用） 校验当前订单类型的下单参数
        ShoppingCartGoodsDto shoppingCartGoodsDto = checkShoppingCartGoodsDto(createOrderBo.getCreateOrderBaseVo());
        createOrderBo.setShoppingCartGoodsDto(shoppingCartGoodsDto);
        // 查询门店信息 营业时间、营业状态，服务器当前时间在营业时间内 点餐桌号
        StoreResponse.BizVO storeResponseDto = checkOrderByStore(createOrderBo.getCreateOrderBaseVo(), trackingNo);
        createOrderBo.setStoreResponseDto(storeResponseDto);
        // 查询小程序自提外卖配置信息 校验当前订单类型的下单参数 校验外卖是否满足起送条件
        checkOrderByOrderType(createOrderBo, trackingNo);

    }

    public abstract void checkCustomCreateOrderParam(CreateOrderBo createOrderBo);

    public CreateOrderBo getCreateOrderBo(CreateOrderBaseVo createOrderBaseVo, AssortmentCustomerInfoVo userLoginInfoDto, String trackingNo) {
        CreateOrderBo createOrderBo = new CreateOrderBo();
        createOrderBo.setCreateOrderBaseVo(createOrderBaseVo);
        createOrderBo.setUserLoginInfoDto(userLoginInfoDto);

        getUniversalCreateOrderBo(createOrderBo);
        getCustomCreateOrderBo(createOrderBo);
        return createOrderBo;
    }

    public void getUniversalCreateOrderBo(CreateOrderBo createOrderBo) {

    }

    public abstract void getCustomCreateOrderBo(CreateOrderBo createOrderBo);

    public abstract void validParam(CreateOrderBaseVo createOrderBaseVo);

    public abstract BaseResponse createSharedOrder(CreateOrderBo createOrderBo);

    public void checkCardCode(CreateOrderBaseVo createOrderBaseVo, AssortmentCustomerInfoVo userLoginInfoDto) {
        if (StringUtils.isBlank(createOrderBaseVo.getCardCode())) {
            return;
        }
        StatisticalPropertyRequest request = new StatisticalPropertyRequest();
        request.setPartnerId(createOrderBaseVo.getPartnerId());
        request.setMemberId(userLoginInfoDto.getMemberId());
        List<GetSvcInfoByMemberIdResponse> svcInfoList = memberPropertyManager.getSvcInfoByMemberId(request, LogThreadLocal.getTrackingNo());
        //svc卡无效
        boolean b = true;
        for (GetSvcInfoByMemberIdResponse getSvcInfoByMemberIdResponse : svcInfoList) {
            if (createOrderBaseVo.getCardCode().equals(getSvcInfoByMemberIdResponse.getCardCode()) && getSvcInfoByMemberIdResponse.getStatusFlag() == 0) {
                b = false;
            }
        }
        if (b) {
            throw new ServiceException(ResponseResult.USER_SVC_CARD_ERROR);
        }
        createOrderBaseVo.setUserId(userLoginInfoDto.getMemberId());
    }

    /**
     * 下单门店相关校验
     */
    public StoreResponse.BizVO checkOrderByStore(CreateOrderBaseVo createOrderBaseVo, String trackingNo) {
        String partnerId = createOrderBaseVo.getPartnerId();
        String shopId = createOrderBaseVo.getShopId();

        // 获取门店信息
        StoreResponse storeResponse = storeInfoManager.getStoreInfo(partnerId, shopId, trackingNo);
        if (storeResponse == null || storeResponse.getBizVO() == null) {
            throw new ServiceException(ResponseResult.STORE_NOT_FOUND);
        }

        //订单预约单检查
        CreateOrderVo vo = new CreateOrderVo();
        BeanUtils.copyProperties(createOrderBaseVo, vo);
        OrderCheckAdapter.check(vo, storeResponse);
        StoreResponse.BizVO storeResponseDto = storeResponse.getBizVO();
        // 校验门店是否停业 1 营业 2 停业 3 繁忙置休
        if (storeResponseDto.getActiveFlag() == null || storeResponseDto.getActiveFlag() != 1) {
            throw new ServiceException(ResponseResult.STORE_ITEM_STOP_BUSINESS);
        }
        createOrderBaseVo.setStoreName(storeResponseDto.getStoreName());
        createOrderBaseVo.setStoreAddress(storeResponseDto.getAddress());
        createOrderBaseVo.setThirdShopId(storeResponseDto.getThirdPartCode());
        return storeResponseDto;
    }

    public ShoppingCartGoodsDto checkShoppingCartGoodsDto(CreateOrderBaseVo createOrderBaseVo) {
        ShoppingCartGoodsDto shoppingCartGoodsDto = getShoppingCartGoodsDto(createOrderBaseVo);
        checkShoppingCartGoods(createOrderBaseVo, shoppingCartGoodsDto);
        return null;
    }

    public ShoppingCartGoodsDto getShoppingCartGoodsDto(CreateOrderBaseVo createOrderBaseVo) {
        return null;
    }

    public abstract ShoppingCartGoodsDto checkShoppingCartGoods(CreateOrderBaseVo createOrderBaseVo, ShoppingCartGoodsDto shoppingCartGoodsDto);

    /**
     * 下单订单类型校验
     */
    public void checkOrderByOrderType(CreateOrderBo createOrderBo, String trackingNo) {
        checkOrderByOrderTypeUniversal(createOrderBo, trackingNo);
        checkOrderByOrderTypeCustom(createOrderBo, trackingNo);
    }

    public void checkOrderByOrderTypeUniversal(CreateOrderBo createOrderBo, String trackingNo) {

    }

    public abstract void checkOrderByOrderTypeCustom(CreateOrderBo createOrderBo, String trackingNo);

    public OrderExtInfoDto getExtInfo(CreateOrderBo createOrderBo) {
        OrderExtInfoDto extInfo = getExtInfoUniversal(createOrderBo);
        createOrderBo.setExtInfo(extInfo);
        getExtInfoCustom(createOrderBo);
        return extInfo;
    }

    public OrderExtInfoDto getExtInfoUniversal(CreateOrderBo createOrderBo) {

        CreateOrderBaseVo createOrderBaseVo = createOrderBo.getCreateOrderBaseVo();
        StoreResponse.BizVO storeResponseDto = createOrderBo.getStoreResponseDto();
        AssortmentCustomerInfoVo userLoginInfoDto = createOrderBo.getUserLoginInfoDto();
        ShoppingCartGoodsDto shoppingCartGoodsDto = createOrderBo.getShoppingCartGoodsDto();

        Integer serviceTime = storeResponseDto.getServiceTime();
        String sessionId = createOrderBaseVo.getSessionId();
        String version = createOrderBaseVo.getVersion();
        CreateOrderBaseVo.BuyMemberCard memberCard = createOrderBaseVo.getBuyMemberCard();

        String deliveryHoursDayStart = "";
        String deliveryHoursDayEnd = "";
        if (StringUtils.isNotBlank(storeResponseDto.getDeliveryHoursDay())) {
            String[] days = storeResponseDto.getDeliveryHoursDay().split("-");
            if (days.length == 2) {
                deliveryHoursDayStart = DateUtil.convert2String(new Date(), DateUtil.FORMAT_yyyyMMdd_date) + " " + days[0] + ":00";
            }
        }

        OrderExtInfoDto orderExtInfoDto = new OrderExtInfoDto();
        orderExtInfoDto.setDeliveryHoursDayStart(deliveryHoursDayStart);
        orderExtInfoDto.setDeliveryHoursDayEnd(deliveryHoursDayEnd);
        orderExtInfoDto.setOpenid(userLoginInfoDto.getOpenId());
        orderExtInfoDto.setAppid(userLoginInfoDto.getWxAppId());
        orderExtInfoDto.setSessionId(sessionId);
        if (Objects.equals(serviceTime, null)) {
            serviceTime = 50;
        }
        orderExtInfoDto.setServiceTime(serviceTime);
        orderExtInfoDto.setVersion(version);
        if (memberCard != null && memberCard.getRuleId() != null) {
            orderExtInfoDto.setRuleId(memberCard.getRuleId());
        }
        // 扩展字段中存储 sessionKey
        orderExtInfoDto.setSessionKey(createOrderBaseVo.getSessionKey());
        orderExtInfoDto.setFormId(createOrderBaseVo.getFormId());
        orderExtInfoDto.setFromAppId(userLoginInfoDto.getWxAppId());
        if (StringUtils.isNotBlank(createOrderBaseVo.getScene())) {
            orderExtInfoDto.setScene(createOrderBaseVo.getScene());
        }
        if (null != shoppingCartGoodsDto && null != shoppingCartGoodsDto.getSendPoint()) {
            ShoppingCartGoodsDto.SendPoint sendPoint = shoppingCartGoodsDto.getSendPoint();
            orderExtInfoDto.setSendPointValidityDateDays(sendPoint.getValidityDateDays());
            orderExtInfoDto.setSendPointMaxNum(sendPoint.getMaxNum());
            orderExtInfoDto.setSendPointActivityCode(sendPoint.getActivityCode());
            orderExtInfoDto.setSendPointEndTime(sendPoint.getEndTime().getTime() + "");
            orderExtInfoDto.setSendPointSendPoint(sendPoint.getSendPoint());
            orderExtInfoDto.setSendPointStoreLevel(sendPoint.getStoreLevel());
        }

        return orderExtInfoDto;
    }

    public abstract void getExtInfoCustom(CreateOrderBo createOrderBo);

    /**
     * 创建预支付订单
     */
    public BaseResponse createPrepayOrder(CreatePrepayRequestDto createPrepayRequestDto) {

        CreateOrderResponseVo createOrderResponse;
        OrderPayResponse orderPayResponse = null;
        PaymentRequest paymentRequest = orderBodyConvertToPaymentBody(createPrepayRequestDto.getOpenId(), createPrepayRequestDto.getPartnerId(), createPrepayRequestDto.getWxAppId(), createPrepayRequestDto.getPayCode());
        long totalAmount = createPrepayRequestDto.getTotalAmount();
        String cardCode = createPrepayRequestDto.getCardCode();
        String transId = createPrepayRequestDto.getTransId();
        if (totalAmount < 0) {
            throw new ServiceException(ResponseResult.PAY_AMOUNT_ERROR);
        } else if (totalAmount > 0 && Objects.nonNull(createPrepayRequestDto.getUnionPayCard())) {
            // 电子风味卡支付
            orderPayResponse = uSvcPay(createPrepayRequestDto.getFatherOrderBean(), paymentRequest, transId, LogThreadLocal.getTrackingNo(), createPrepayRequestDto.getUnionPayCard());
        } else if (totalAmount > 0 && StringUtils.isBlank(cardCode)) {
            String partnerPayOvertime = this.getPartnerPayOvertime(createPrepayRequestDto.getPartnerId());
            orderPayResponse = getPreOrderPay(createPrepayRequestDto.getFatherOrderBean(), paymentRequest, LogThreadLocal.getTrackingNo(), createPrepayRequestDto.getCardAmount(), transId, partnerPayOvertime, createPrepayRequestDto.getOrderExtInfoDTO());
        }
        //混合支付+svc卡
        else if (totalAmount > 0 && StringUtils.isNotBlank(cardCode)) {
            orderPayResponse = switchSvcOrComb(totalAmount, cardCode, createPrepayRequestDto.getFatherOrderBean(), paymentRequest, transId, createPrepayRequestDto.getChannel(), createPrepayRequestDto.getStoreId(), LogThreadLocal.getTrackingNo());
        } else {
            // 0元订单如果不需要支付，自定义支付单号
            orderPayResponse = getOrderPayResponse(paymentRequest, createPrepayRequestDto.getFatherOrderBean());
        }
        if (orderPayResponse == null || Objects.isNull(orderPayResponse.getFmId())) {
            BaseResponse baseResponse = failPreOrderPay(LogThreadLocal.getTrackingNo(), createPrepayRequestDto.getProductOrderBean(), cardCode, createPrepayRequestDto.getOrderClient(),
                    Objects.isNull(orderPayResponse) ? null : orderPayResponse.getMsg());
            // 电子风味卡需要给用户特殊的返回
            if (totalAmount > 0 && Objects.nonNull(createPrepayRequestDto.getUnionPayCard())) {
                baseResponse.setMessage(Objects.nonNull(orderPayResponse) &&
                        (ResponseCodeConstant.PASSWORD_WRONG.equals(orderPayResponse.getPayTransId())
                                || ResponseCodeConstant.NOT_SUFFICIENT_FUND.equals(orderPayResponse.getPayTransId())) ?
                        orderPayResponse.getMsg() : "支付失败");
            }
            return baseResponse;
        }
        createOrderResponse = orderAdapter.convent2CreateFatherSonOrderResponseVo(orderPayResponse, createPrepayRequestDto.getProductOrderBean());
        BaseResponse baseEditResponse = this.updateOrderInfo(orderPayResponse, createPrepayRequestDto.getOrderExtInfoDTO(), createPrepayRequestDto.getProductOrderBean(), LogThreadLocal.getTrackingNo());
        if (baseEditResponse != null) {
            return baseEditResponse;
        }
        if (totalAmount > 0 && StringUtils.isBlank(cardCode) && Objects.isNull(createPrepayRequestDto.getUnionPayCard())) {
            createOrderResponse.setPaySuccess(false);
        } else if (StringUtils.isNotBlank(orderPayResponse.getPayMode()) && PayChannelType.COMB.getEbcode().equals(orderPayResponse.getPayMode())) {
            createOrderResponse.setPaySuccess(false);
        } else if (StringUtils.isNotBlank(orderPayResponse.getPayMode()) && PayChannelType.SVC.getEbcode().equals(orderPayResponse.getPayMode())) {
            createOrderResponse.setPaySuccess(true);
        } else {
            createOrderResponse.setPaySuccess(true);
        }
        // 推荐优惠插件用户下单数据上报
        //wechatPushProcessor.statusOrderCreate(userLoginInfoDto, createOrderResponse.getOid(), createOrderVo.getPartnerId());
        if (!createOrderResponse.getPaySuccess()) {
            return ResponseUtil.success(createOrderResponse);
        } else {
            //如果是商品券支付0元，调用回调接口
            /**
             *  - 老的svc卡或是0元订单下单成功直接核销 这里不处理
             *  - 混合支付纯svc支付 需要直接内部核销 其他支付方式需依靠外部回调
             *  -
             */
            PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
            message.setResult_code(100);
            message.setOut_trade_no(createOrderResponse.getFmId());
            message.setTrans_id(createOrderResponse.getOid());
            message.setTotal_fee(0);
            message.setOpenid(createPrepayRequestDto.getOpenId());
            message.setPlatform_coupon(0);
            message.setMerchant_coupon(0);
            message.setSource(PaySuccessSource.OUTSIDE.getSource());
            /*
            if (StringUtils.isNotBlank(orderPayResponse.getPayMode()) && PayChannelType.SVC.getEbcode().equals(orderPayResponse.getPayMode())) {
                message.setSource(PaySuccessSource.OUTSIDE.getSource());
            }
             */
            orderAdapterService.paySuccessCallback(message);
            return ResponseUtil.success(createOrderResponse);
        }
    }
}
