package cn.freemud.adapter;

import cn.freemud.entities.dto.order.CreateOrderOperateDto;
import cn.freemud.entities.dto.order.CreatePrepayRequestDto;
import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.CreateOrderVo;
import com.alibaba.fastjson.JSON;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import lombok.Data;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class CreateOrderAdapter {

    public CreatePrepayRequestDto convertToCreatePrepayRequestDto(AssortmentCustomerInfoVo userLoginInfoDto, CreateOrderBaseVo createOrderBaseVo,
                                                                  CreateOrderOperateDto createOrderOperateDto, OrderExtInfoDto orderExtInfoDTO){
        CreatePrepayRequestDto requestDto = new CreatePrepayRequestDto();
        requestDto.setPartnerId(createOrderBaseVo.getPartnerId());
        requestDto.setWxAppId(userLoginInfoDto.getWxAppId());
        requestDto.setOpenId(userLoginInfoDto.getOpenId());
        requestDto.setFaceCode(createOrderBaseVo.getCardCode());
        requestDto.setCardCode(createOrderBaseVo.getCardCode());
        requestDto.setPayCode(null);
        requestDto.setFatherOrderBean(createOrderOperateDto.getFatherOrderBean());
        requestDto.setProductOrderBean(createOrderOperateDto.getProductOrderBean());
        requestDto.setTotalAmount(createOrderOperateDto.getTotalAmount());
        requestDto.setCardAmount(createOrderOperateDto.getCardAmount());
        requestDto.setOrderExtInfoDTO(orderExtInfoDTO);
        requestDto.setTransId(createOrderOperateDto.getFatherOrderBean().getOid());
        requestDto.setOrderClient(null);
        requestDto.setUnionPayCard(createOrderBaseVo.getUnionPayCard());
        requestDto.setStoreId(createOrderBaseVo.getShopId());
        requestDto.setChannel(createOrderBaseVo.getChannel());
        return requestDto;
    }
}