package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class GetStoreCloudPrintResponseDto {

    /**
     * code : 100
     * message : success
     * ver : 1
     * result : [{"printId":1,"partnerId":"1810","storeId":"123456","machineCode":"4004571797","msign":"47z66346qn6t","printName":"打印机名称","printType":1,"printNumber":1,"printSound":2,"status":1}]
     */

    private String code;
    private String message;
    private String ver;
    private List<PrintnerBean> result;

    @NoArgsConstructor
    @Data
    public static class PrintnerBean {
        /**
         * printId : 1
         * partnerId : 1810
         * storeId : 123456
         * machineCode : 4004571797
         * msign : 47z66346qn6t
         * printName : 打印机名称
         * printType : 1
         * printNumber : 1
         * printSound : 2
         * status : 1
         */
        /**
         * 打印机编号
         */
        private Long printerId;
        /**
         * 商户号
         */
        private String partnerId;
        /**
         * 门店号
         */
        private String storeId;
        /**
         * 打印机终端号
         */
        private String machineCode;
        /**
         * 打印机终端密钥
         */
        private String msign;
        /**
         * 打印机终端名称
         */
        private String printName;
        /**
         * 打印机类型 (1=小票，2=杯贴)
         */
        private Integer printType;
        /**
         * 打印数量
         */
        private Integer printNumber;
        /**
         * 打印提示音 (0:蜂鸣器提示，1:语音提示)
         */
        private Integer printSound;
        /**
         * 打印机状态 （1=在线 2=缺纸 0=离线）
         */
        private Integer status;
    }
}
