package cn.freemud.fuyou.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.fuyou.controller.request.CompleteRequest;
import cn.freemud.fuyou.controller.request.CreateOrderRequest;
import cn.freemud.fuyou.controller.request.RefundRequest;
import cn.freemud.fuyou.service.FuYouOrderService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
/***
 *
 */
@RestController
@RequestMapping("fuYou/order")
public class FuYouOrderController {
    private final FuYouOrderService fuyouOrderService;

    public FuYouOrderController(FuYouOrderService fuyouOrderService) {
        this.fuyouOrderService = fuyouOrderService;

    }

    /**
     * 下单
     * @param request
     * @return
     */
    @ApiAnnotation(logMessage = "/submit")
    @PostMapping("/submit")
    public BaseResponse submit(@Validated @LogParams @RequestBody CreateOrderRequest request) {
        return fuyouOrderService.createOrder(request);
    }

    /**
     * 退款
     * @param request
     * @return
     */
    @ApiAnnotation(logMessage = "/refund")
    @PostMapping("/refund")
    public BaseResponse refundOperation(@Validated @LogParams @RequestBody  RefundRequest request) {
        return fuyouOrderService.refund(request);
    }

    /**
     * 订单完成
     * @param request
     * @return
     */
    @ApiAnnotation(logMessage = "/complete")
    @PostMapping("/complete")
    public BaseResponse complete(@Validated @LogParams @RequestBody CompleteRequest request) {
        return fuyouOrderService.complete(request);
    }


}
