package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * @author liming.guo
 * @date 2018/05/08
 */
@Data
public class RegisterByUnionIdRequestVo {

    /**
     * 用户code，获取openid
     */
    @ApiModelProperty(value = "加密的微信用户信息", name = "encryptedData", required = true)
    @NotEmpty(message = "encryptedData 不能为空")
    private String encryptedData;

    @ApiModelProperty(value = "iv", name = "iv", required = true)
    @NotEmpty(message = "iv 不能为空")
    private String iv;


    @ApiModelProperty(value = "sessionId", name = "sessionId")
    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    /**
     * 商户id
     */
    @ApiModelProperty(value = "商户partnerId", name = "partnerId", required = true)
    @NotEmpty(message = "partnerId 不能为空")
    private String partnerId;

    @ApiModelProperty(value = "微信appId", name = "appId", required = true)
    @NotEmpty(message = "appId 不能为空")
    private String appId;
    
    @ApiModelProperty(value = "设备品牌", name = "devBrand")
//    @NotEmpty(message = "devBrand 不能为空")
    private String devBrand;
    
    @ApiModelProperty(value = "设备型号", name = "devModel")
//    @NotEmpty(message = "devModel 不能为空")
    private String devModel;
    
    @ApiModelProperty(value = "登录渠道", name = "channel")
//    @NotEmpty(message = "channel 不能为空")
    private String channel;
    
    @ApiModelProperty(value = "客户端事件发生毫秒时间戳", name = "cts")
//    @NotEmpty(message = "cts 不能为空")
    private String cts;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
