package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.takeaway.request.order.PlatformOrderRequest;
import com.freemud.application.sdk.api.takeaway.service.WaimaiOrderService;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: rrr
 * @Package cn.freemud.management.service.impl
 * @Description: 外卖订单履单操作
 * @author: shuhu.hou
 * @date: 2020/3/26 16:01
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class WaimaiOrderMangerServiceImpl implements OrderManagerService {

    @Autowired
    private WaimaiOrderService waimaiOrderService;

    @Override
    public BaseResponse<OrderManagerResponse> orderConfirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        PlatformOrderRequest platformOrderRequest = new PlatformOrderRequest();
        platformOrderRequest.setPlatformOrderId(orderBean.getCustomerOrder());
        platformOrderRequest.setChannel(orderBean.getSource());
        platformOrderRequest.setCompanyId(orderBean.getCompanyId());
        platformOrderRequest.setOrderId(orderBean.getOid());
        platformOrderRequest.setShopId(orderBean.getShopId());
        platformOrderRequest.setOperator(request.getOperator());
        com.freemud.application.sdk.api.base.BaseResponse waimaiBaseResponse = waimaiOrderService.confirm(platformOrderRequest, LogTreadLocal.getTrackingNo());
        if(ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(),waimaiBaseResponse.getCode())){
            return ResponseUtil.error(ResponseResult.ORDER_ACCEPT_FAILED);
        }
        return ResponseUtil.success();
    }
}
