package cn.freemud.service;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.vo.GetMemberCouponRequestVo;
import cn.freemud.utils.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.freemud.card.sdk.comm.Finals;
import com.freemud.card.sdk.comm.SignUtil;
import com.freemud.card.sdk.service.*;
import com.freemud.card.sdk.util.DateUtil;
import com.freemud.card.sdk.vo.comm.GetCodeRespVo;
import com.freemud.card.sdk.vo.comm.GetCouponVo;
import com.freemud.card.sdk.vo.coupon.CouponVo;
import com.freemud.card.sdk.vo.coupon.MemberCouponVo;
import com.freemud.card.sdk.vo.coupon.request.ActiveInsertRequest;
import com.freemud.card.sdk.vo.coupon.request.MemberCardVo;
import com.freemud.card.sdk.vo.coupon.request.PromotionUserCouponReqVo;
import com.freemud.card.sdk.vo.coupon.response.ActiveInsertRespVo;
import com.freemud.card.sdk.vo.coupon.response.MemberCouponRespVo;
import com.freemud.card.sdk.vo.coupon.response.PromotionBaseRespVo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.card.sdk
 * @Description:
 * @author: genyou.cui
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class CouponTest {

    private static final Logger logger = LoggerFactory.getLogger(CouponTest.class);
    @Autowired
    private FMCouponService fmCouponService;
    @Autowired
    private FMActiveService fmActiveService;
    @Autowired
    private GetCouponService getCouponService;
    @Autowired
    private MemberProductService memberProductService;
    @Autowired
    private PromotionService promotionService;
    @Autowired
    private RedeemCouponService redeemCouponService;
    @Autowired
    private CouponService couponService;
    @Test
    public void testGetCoupon() {
        String fileName = "getCoupons";
        GetCouponVo getCouponVo = FileUtil.getObjectFromFile(fileName, GetCouponVo.class);
        GetCodeRespVo codeRespVo = getCouponService.getCoupons(getCouponVo);
        logger.info(JSONObject.toJSONString(codeRespVo));

    }

    @Test
    public void couponCreate() {
        String partnerId = "1864";
        MultiValueMap<String, String> couponOnlineMap = new LinkedMultiValueMap<>();
        couponOnlineMap.add(Finals.PARTNER_ID, partnerId);
        couponOnlineMap.add(Finals.MERCHANT_ID, partnerId);
        couponOnlineMap.add(Finals.ORDER_ID, "ISAASTest123456789");
        couponOnlineMap.add(Finals.ACTIVECODE, "C201811151617006zhvy");
        couponOnlineMap.add(Finals.VALID_ENDS, "2019-12-01 00:00:00");
        couponOnlineMap.add(Finals.VALID_START, "2018-12-01 00:00:00");
        String mobile = "15651101234";
        couponOnlineMap.add(Finals.MOBILE, mobile);

        couponOnlineMap.add(Finals.TITLE, "cyj可领5次券");
        couponOnlineMap.add(Finals.TIMESTAMP, DateUtil.getCurrentDate(DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        couponOnlineMap.add(Finals.NUMBER, "1");
        couponOnlineMap.add(Finals.ACTION, "code.create");

        String appSecret = "C0CB6FCDE7C745F4AEE81A152F77B728";
        Map<String, String> signMap = couponOnlineMap.toSingleValueMap();
        String sign = SignUtil.createMD5Sign(signMap, appSecret);
        couponOnlineMap.add(Finals.SIGN, sign);

//        CouponCreateResponseVo code = fmCouponService.createCode(couponOnlineMap);
//        logger.info(JSONObject.toJSONString(code));
    }

    @Test
    public void promotionSaveUserCoupon() {
        String partnerId = "1864";
        String mobile = "15651101234";
        String activityCode = "MEHG2018121719200242839";
        String code = "88600017957001943687";
        PromotionUserCouponReqVo promotionUserCouponReqVo = new PromotionUserCouponReqVo();
        promotionUserCouponReqVo.setVer(1);
        promotionUserCouponReqVo.setPartnerCode(partnerId);
        promotionUserCouponReqVo.setUserId("115393308065249235");
        promotionUserCouponReqVo.setMobile(mobile);
        List<CouponVo> coupons = new ArrayList<>();
        CouponVo couponVo = new CouponVo();
        couponVo.setCouponCode(code);
        couponVo.setActivityCode(activityCode);
        String startDate = "2018-12-01 00:00:00";
        String endDate = "2019-12-01 00:00:00";
        couponVo.setValidityPeriodStart(DateUtil.convert2Date(startDate, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        couponVo.setValidityPeriodEnd(DateUtil.convert2Date(endDate, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        coupons.add(couponVo);
        promotionUserCouponReqVo.setCoupons(coupons);

        PromotionBaseRespVo promotionBaseRespVo = promotionService.saveUserCoupon(promotionUserCouponReqVo);
        logger.info(JSONObject.toJSONString(promotionBaseRespVo));
    }

    @Test
    public void getmembercoupon() {
        //1617,1617，88600017957134272219
        String partnerId = "1617";
        String memberId = "1617";
        String code = "88600017957134272219";
        MemberCardVo memberCardVo = new MemberCardVo();
        memberCardVo.setPartnerId(partnerId);
        memberCardVo.setMemberId(memberId);
        memberCardVo.setCouponCode(code);
        MemberCouponRespVo<MemberCouponVo> memberCoupon = memberProductService.getMemberCoupon(memberCardVo);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }

    @Test
    public void getMemberCoupon() {
        //1617,1617，88600017957134272219
        String partnerId = "1864";
        String memberId = "1864";
        String code = "88600369801000970417";
        GetMemberCouponRequestVo requestVo=new GetMemberCouponRequestVo();
        requestVo.setCouponCode(code);
        requestVo.setPartnerId(partnerId);
        requestVo.setSessionId("8ecf77ce6af7d266fbbfc990b6e0918a1127e34a");
        GetCouponDetailResponseDto memberCoupon = couponService.getMemberCoupon(requestVo);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }
    @Test
    public void checkSpqInfo() {
        //1617,1617，88600017957134272219
        String partnerId = "1864";
        String memberId = "1617";
        /*
        String code = "88600039947518452055";
        partnerId = "1864";
        memberId  = "1617";
        code      = "88600039947518452055";
        */
        String code = "88607422333514819844";
        partnerId = "2399";
        memberId = "2399";
        code = "88607422333514819844";


        CheckSpqInfoRequestDto requestDto = new CheckSpqInfoRequestDto();
        requestDto.setCouponCode(code);
        requestDto.setPartnerId(partnerId);
        requestDto.setStoreId("");
        CheckSpqInfoResponseDto memberCoupon = couponService.checkSpqInfo(requestDto);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }

    @Test
    public void addCouponActive() {
        String req="{\n" +
                "    \"Active\": {\n" +
                "        \"EBCode\": \"0000000517\",\n" +
                "        \"Type\": 1,\n" +
                "        \"PartnerID\": 1864,\n" +
                "        \"PlatformItemId\": \"\",\n" +
                "        \"State\": 1,\n" +
                "        \"ActiveCode\": \"TS201812181845001\",\n" +
                "        \"ActiveName\": \"SDK代金券测试\",\n" +
                "        \"ActiveDesc\": \"SDK代金券测试\",\n" +
                "        \"CreateUser\": \"SDKadmin\",\n" +
                "        \"CreateDate\": \"2018-12-18T19:05:23\",\n" +
                "        \"LastEditUser\": \"SDKadmin\",\n" +
                "        \"LastEditDate\": \"2018-12-18T19:05:23\",\n" +
                "        \"StartDate\": \"2018-12-18T00:00:00\",\n" +
                "        \"EndDate\": \"2019-12-18T00:00:00\",\n" +
                "        \"ShouldRedeemAll\": 0,\n" +
                "        \"PromotionType\": \"AAA\",\n" +
                "        \"Exclusive\": null,\n" +
                "        \"MinAmount\": 1000,\n" +
                "        \"MaxRedeemTimes\": 1000,\n" +
                "        \"MaxSendOut\": 100,\n" +
                "        \"Cost\": 3.0,\n" +
                "        \"BusinessID\": 1\n" +
                "    },\n" +
                "    \"ActiveProduct\": [\n" +
                "        {\n" +
                "            \"ProductID_Partner\": \"1234567\",\n" +
                "            \"Product\": \"SDK3元代金券\",\n" +
                "            \"Price_Original\": 3,\n" +
                "            \"Price_Discount\": 3,\n" +
                "            \"Amount\": 1,\n" +
                "            \"Paid\": 3,\n" +
                "            \"Remain\": 0\n" +
                "        }\n" +
                "    ],\n" +
                "    \"ActiveRestrict\": [\n" +
                "        {\n" +
                "            \"City\": \"\",\n" +
                "            \"StoreIDPartner\": \"10086\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"ActiveProductSetting\": [\n" +
                "        {\n" +
                "            \"ProductCode\": \"01000009\",\n" +
                "            \"CategoryCode\": \"\",\n" +
                "            \"Type\": 0\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        String appSecret = "C0CB6FCDE7C745F4AEE81A152F77B728";
        ActiveInsertRequest activeInsertRequest = JSONObject.parseObject(req, ActiveInsertRequest.class);
        activeInsertRequest.setAppSecret(appSecret);
        ActiveInsertRespVo activeInsertRespVo = fmActiveService.insertActive(activeInsertRequest);
        logger.info(JSONObject.toJSONString(activeInsertRespVo));
    }



}
