/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.active.impl;

import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.CalculationGoodsType;
import cn.freemud.service.active.ActiveService;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("cocoActiveService")
public class CocoActiveServiceImpl implements ActiveService {

    /**
     * 用户只能选择1商品和1数量传给促销
     * @param calculationSharingDiscountRequestDto
     * @param chooseGoods
     */
    @Override
    public void buildChooseGoodsService(CalculationSharingDiscountRequestDto calculationSharingDiscountRequestDto, List<ShoppingCartInfoRequestVo.ChooseGood> chooseGoods) {

        // 买一赠一寄件活动
        // coco一次只能选择一种商品，一种商品只能选择一件
        List<CalculationSharingDiscountRequestDto.CalculationActivityReqVO> selectActivityList = calculationSharingDiscountRequestDto.getSelectActivityList() == null ? new ArrayList<>() : calculationSharingDiscountRequestDto.getSelectActivityList();

        if(null != chooseGoods && !chooseGoods.isEmpty()){

            // 从用户选择的商品中选择第一个
            ShoppingCartInfoRequestVo.ChooseGood chooseGood = chooseGoods.get(0);

            CalculationSharingDiscountRequestDto.CalculationActivityReqVO  calculationActivityReqVO = new CalculationSharingDiscountRequestDto.CalculationActivityReqVO();
            calculationActivityReqVO.setActivityCode(chooseGood.getActiveCode());
            calculationActivityReqVO.setActivityType(ActivityTypeEnum.TYPE_63.getCode());

            // 设置商品的数量为1
            List<CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO> sendGoods = new ArrayList<>();
            CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO sendGood = new CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO();
            sendGood.setGoodsId(chooseGood.getGoodsId());
            sendGood.setGoodsQuantity(1);
            sendGoods.add(sendGood);
            calculationActivityReqVO.setSendGoods(sendGoods);

            selectActivityList.add(calculationActivityReqVO);
        }
        calculationSharingDiscountRequestDto.setSelectActivityList(selectActivityList);

    }

    @Override
    public void gifAddCart(List<CartGoods> oldcartGoodsLists,
                           List<CartGoods> addcartGoodsList,
                           List<ProductBeanDTO> products ,
                           ShoppingCartInfoRequestVo shoppingCartInfoRequestVo,
                           CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult,
                           String partnerId) {

        // 点餐页赠品分行显示，赠品显示小料
        // 结束页赠品合并到主商品行
        // 创单查询购物车分行显示
        Map<String, CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> discountForGift = this.getDiscountForGift(discountResult);
        if(ObjectUtils.equals(partnerId,1)){//结算页
            for(CartGoods cgs : oldcartGoodsLists){
                if(null == discountForGift.get(cgs.getCartGoodsUid())){
                    break;
                }

                CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods gift = discountForGift.get(cgs.getCartGoodsUid());

                cgs.setQty(cgs.getQty() + (gift.getGoodsQuantity() == null ? 0 : gift.getGoodsQuantity()));

            }
        }else{
            for(CartGoods cgs : oldcartGoodsLists){
                if(null == discountForGift.get(cgs.getCartGoodsUid())){
                    break;
                }

                if(null == discountForGift.get(cgs.getCartGoodsUid()).getDiscounts() || discountForGift.get(cgs.getCartGoodsUid()).getDiscounts().isEmpty()){
                    break;
                }

                CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods.GoodsDiscount discount = discountForGift.get(cgs.getCartGoodsUid()).getDiscounts()
                        .stream()
                        .filter(g -> ActivityTypeEnum.TYPE_63.getCode().equals(g.getType()) ||ActivityTypeEnum.TYPE_62.getCode().equals(g.getType()) || ActivityTypeEnum.TYPE_61.getCode().equals(g.getType()))
                        .findFirst()
                        .get();


                CartGoods newCartGoods = new CartGoods();
                newCartGoods.setCartGoodsUid(cgs.getCartGoodsUid());
                newCartGoods.setGoodsId(cgs.getGoodsId());
                newCartGoods.setGoodsType(cgs.getGoodsType());
                newCartGoods.setSpuId(cgs.getSpuId());
                newCartGoods.setSkuId(cgs.getSkuId());
                newCartGoods.setSpecProductId(cgs.getSpecProductId());
                newCartGoods.setOriginalPrice(cgs.getOriginalPrice());
                newCartGoods.setPackPrice(cgs.getPackPrice());
                newCartGoods.setOriginalAmount(cgs.getOriginalAmount());
                newCartGoods.setAmount(0L);
                newCartGoods.setName(cgs.getName());
                newCartGoods.setSpuName(cgs.getSpuName());
                newCartGoods.setSubName(cgs.getSubName());
                newCartGoods.setNodeId(cgs.getNodeId());
                newCartGoods.setCategoryName(cgs.getCategoryName());
                List<CartGoods.CartGoodsExtra> extra = Lists.newArrayList();
                List<CartGoods.CartGoodsExtra> cartGoodsExtras = cgs.getExtra();
                if (CollectionUtils.isNotEmpty(cartGoodsExtras)) {
                    cartGoodsExtras.forEach(cartGoodsExtra -> {
                        CartGoods.CartGoodsExtra goodsExtra = new CartGoods.CartGoodsExtra();
                        goodsExtra.setAttributeId(cartGoodsExtra.getAttributeId());
                        goodsExtra.setAttributeName(cartGoodsExtra.getAttributeName());
                        extra.add(goodsExtra);
                    });
                }
                newCartGoods.setExtra(extra);
                newCartGoods.setPic(cgs.getPic());
                newCartGoods.setCreateTimeMili(cgs.getCreateTimeMili());
                newCartGoods.setSkuName(cgs.getSkuName());
                newCartGoods.setSkuName(cgs.getSkuName());
                newCartGoods.setClassificationId(cgs.getClassificationId());
                newCartGoods.setClassificationName(cgs.getClassificationName());
                newCartGoods.setActivityType(discount.getType());
                addcartGoodsList.add(newCartGoods);
            }
        }
    }

    public Map<String, CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> getDiscountForGift(CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult) {

        Map<String, CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> gifts = new HashMap<>();

        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        if(goods == null || goods.isEmpty()){
            return gifts;
        }

        for(CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods g : goods){
            if(!CalculationGoodsType.TYPE_1.getType().equals(g.getCartGoodType())){
                continue;
            }

            if(null != gifts.get(g.getCartGoodsUid())){
                continue;
            }

            gifts.put(g.getOriginalGoodsUid(),g);
        }

        return gifts;
    }


}
