/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.UUID;

@Data
public class ShoppingCartGoodsResponseVo  extends ShoppingCartGoodsBaseResponseVo{

    /**
     * 商品额外的属性
     */
    List<CartGoods> products;
    /**
     * 商品总数
     */
    private Integer productsCount;
    /**
     * 活动信息
     */
    private ActivityTip activityTip;

    /**
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价
     */
    private Long totalDiscountAmount;

    /**
     * 新包装费（该字段给新版本前端展示，使其好计算）
     */
    private Long newPackAmount;

    /**
     * 优惠券折扣
     */
    private Long couponDiscount;

    /**
     * 满减折扣
     */
    private Long fullDiscount;
    /**
     * svc卡支付描述
     */
    private String svcDiscountDesc;

    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;

    private ActivityTip buyOneGetActivity;
    /**
     * 积分抵扣优惠
     */
    private ShoppingCartCustomerScoreVo customerScoreVo;
    /**
     * 起送费
     */
    private Long freeDeliveryPrice;
    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 减免后配送费
     */
    private Long discountDeliveryAmount;

    /**
     * 满多少额度 减免
     */
    private Long thresholdAmount;

    /**
     * 是否参加满额减免
     */
    @Builder.Default
    private Boolean isDiscountDelivery = false;

    /**
     * 满额减配送费描述
     */
    private String deliveryDiscountDesc;

    /**
     * 减免后配送费
     */
    private String discountDeliveryActivityCode;

    /**
     * 配送费为零的原因：0:正常,1:超出配送范围
     */
    private Integer deliveryFeeZeroReason;

    /**
     * 代金券
     */
    private String couponCode;

    /**
     * 运费券
     */
    private String freightCouponCode;
    private Integer version;

    /**
     * 麦咖啡-咖啡月卡价格
     */
    private Long payCardFee;
    /**
     * 购物车版本号
     */
    private Integer carVer;

    /**
     * 支付金额
     */
    private String svcPayAmount;

    /**
     * 总的优惠信息集合
     */
    private List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Discount> discounts;

    /**
     * 商品优惠信息
     */
    private List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods;

    /**
     * 用户可以选择的商品
     */
    private List<chooseGood> chooseGoods;

    @Data
    public static class chooseGood {

        /**
         * 购物车一行的Id（后台生成）
         */
        private String cartGoodsUid;

        /**
         * 活动code
         */
        private String activeCode;

        /**
         * 活动类型
         */
        private Integer activeType;

        /**
         * 赠送商品名称
         */
        private String goodsName;

        /**
         * 赠送商品id
         */
        private String goodsId;

        /**
         * 赠送商品数量
         */
        private Integer qty;

        /**
         * 可兑换商品券编号
         */
        private String couponCode ;

        /**
         * 可兑换券的数量
         */
        private Integer couponQty ;

        /**
         *  可兑换商品券名称
         */
        private String couponName ;

        /**
         *  是否已选择寄杯
         */
        private Boolean sendCoupon;
    }
}
