/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PaymentClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 支付服务
 * @author: liming.guo
 * @date: 2018/5/12519:24
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.pay.CombPayResponse;
import cn.freemud.entities.dto.pay.MultiQueryRequest;
import cn.freemud.entities.dto.pay.MultiQueryRespDto;
import com.freemud.sdk.api.assortment.order.request.payment.CombPayRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;


@FeignClient(name = "multi-pay-center-api",url="${saas.paymentcenter.application.api.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface ComPayClient {

    /**
     * 混合支付统一下单
     */
    @LogIgnoreFeign(logMessage="combPay",messageFieldName= ResponseCodeKeyConstant.MSG)
    @PostMapping("/payment/application/pay")
    CombPayResponse combPay(@RequestBody CombPayRequest combPayRequest, @RequestHeader("partnerId") String partnerId);

    /**
     * 混合支付查询接口
     */
    @LogIgnoreFeign(logMessage="paymentApplicationQuery",messageFieldName= ResponseCodeKeyConstant.MSG)
    @PostMapping("/payment/application/query")
    MultiQueryRespDto paymentApplicationQuery(@RequestBody MultiQueryRequest multiQueryRequest, @RequestHeader("partnerId") Integer partnerId);

}
