package cn.freemud.entities.dto;

import com.google.gson.annotations.SerializedName;
import lombok.Data;


/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OptRequestDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/27 19:14
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class OptRequestDto {
    @SerializedName("appid")
    private String appId;
    @SerializedName("mch_id")
    private String mchId;
    @SerializedName("sub_appid")
    private String subAppId;
    @SerializedName("sub_mch_id")
    private String subMchId;
    private String secret;
    /**
     * 枚举值，MOBILE手机小程序，SCREEN线下大屏幕推荐入口，POS店员收银台推荐入口
     */
    private String scene;
    /**
     * 推荐标志，请求推荐结果返回的trace_id
     */
    @SerializedName("trace_id")
    private String traceId;
    /**
     * 门店行政区域码
     */
    @SerializedName("area_code")
    private String areaCode;
    /**
     * 门店编号
     */
    @SerializedName("store_id")
    private String storeId;
    /**
     * 门店名称
     */
    @SerializedName("store_name")
    private String storeName;
    /**
     * 上报来源，线下门店填OFFLINE,小程序填MINI_PROGRA
     */
    @SerializedName("action_source")
    private String actionSource;
    @SerializedName("openid")
    private String openId;
    /**
     * 手机号和openid二选一，优先填openid
     */
    @SerializedName("mobile_num_hash")
    private String mobileNumHash;
    /**
     * 服务商模式下必填
     */
    @SerializedName("sub_openid")
    private String subOpenId;
    /**
     * 用户行为数据列表
     */
    @SerializedName("action_list")
    private String actionList;

}
