package com.freemud.application.sdk.api.ordercenter.service;

import com.freemud.application.sdk.api.base.BaseRequest;
import com.freemud.application.sdk.api.log.ThirdPartyLog;
import com.freemud.application.sdk.api.ordercenter.config.OrderCenterProperties;
import com.freemud.application.sdk.api.ordercenter.config.OrderDownLoadCenterProperties;
import com.freemud.application.sdk.api.ordercenter.constant.InterfaceAddressConstant;
import com.freemud.application.sdk.api.ordercenter.enums.ResponseResultEnum;
import com.freemud.application.sdk.api.ordercenter.request.OrderConditionsReq;
import com.freemud.application.sdk.api.ordercenter.request.QueryOrderByScrollRequest;
import com.freemud.application.sdk.api.ordercenter.response.BaseDownLoadResponse;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp;
import com.freemud.application.sdk.api.ordercenter.response.QueryOrderForUserResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.QueryByCodeResponse;
import com.freemud.application.sdk.api.ordercenter.util.ResponseUtil;
import com.freemud.application.sdk.api.util.RequestThirdPartyUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.application.sdk.api.ordercenter.service
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/8/1
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@Service
@Slf4j
public class OrderDownLoadSdkService {

    @Autowired
    @Qualifier("orderDownLoadRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private OrderDownLoadCenterProperties orderCenterProperties;
    public static final String SUCCESS_RESPONSE_CODE = "100";

    /**
     * 根据综合条件查询订单
     */
    public BaseDownLoadResponse<List<OrderInfoReqs>> queryOrderByConditions(OrderConditionsReq request, String trackingNo) {
        long begin = System.currentTimeMillis();
        BaseDownLoadResponse<List<OrderInfoReqs>> responseDTO = RequestThirdPartyUtils.httpJsonReqComplexDownLoad(restTemplate, InterfaceAddressConstant.QUERY_ORDER_BY_CONDITIONS,
                createBaseRequest(request, trackingNo), new ParameterizedTypeReference<BaseDownLoadResponse<List<OrderInfoReqs>>>() {
                });
        ThirdPartyLog.infoConvertJson(begin, System.currentTimeMillis(), InterfaceAddressConstant.QUERY_ORDER_BY_CONDITIONS, request, responseMini(responseDTO));
        return responseHandle(responseDTO);
    }

    public BaseDownLoadResponse<List<OrderInfoReqs>> queryOrderByScroll(QueryOrderByScrollRequest request, String trackingNo) {
        long begin = System.currentTimeMillis();
        BaseDownLoadResponse<List<OrderInfoReqs>> responseDTO = RequestThirdPartyUtils.httpJsonReqComplexDownLoad(restTemplate, InterfaceAddressConstant.QUERY_ORDER_BY_SCROLL,
                createBaseRequest(request, trackingNo), new ParameterizedTypeReference<BaseDownLoadResponse<List<OrderInfoReqs>>>() {
                });
        ThirdPartyLog.infoConvertJson(begin, System.currentTimeMillis(), InterfaceAddressConstant.QUERY_ORDER_BY_SCROLL, request, responseMini(responseDTO));
        return responseHandle(responseDTO);
    }

    BaseDownLoadResponse responseMini(BaseDownLoadResponse responseDTO){

        BaseDownLoadResponse baseDownLoadResponse = new BaseDownLoadResponse();

        if(responseDTO == null){
            return baseDownLoadResponse;
        }

        baseDownLoadResponse.setCode(responseDTO.getCode());
        baseDownLoadResponse.setMessage(responseDTO.getMessage());
        baseDownLoadResponse.setVer(responseDTO.getVer());
        baseDownLoadResponse.setScrollId(responseDTO.getScrollId());
        baseDownLoadResponse.setTotalNum(responseDTO.getTotalNum());
        baseDownLoadResponse.setNumber(responseDTO.getNumber());

        return baseDownLoadResponse;
    }

    private <T> BaseDownLoadResponse<T> responseHandle(BaseDownLoadResponse<T> responseDTO) {
        BaseDownLoadResponse baseDownLoadResponse = new BaseDownLoadResponse();
        if (responseDTO == null) {
            baseDownLoadResponse.setCode(ResponseResultEnum.SYSTEM_BUSINESS_ERROR.getCode());
            baseDownLoadResponse.setMessage(ResponseResultEnum.SYSTEM_BUSINESS_ERROR.getMessage());
            return baseDownLoadResponse;
        }
        if (!Objects.equals(SUCCESS_RESPONSE_CODE, responseDTO.getCode())) {
            baseDownLoadResponse.setCode(ResponseResultEnum.SYSTEM_BUSINESS_ERROR.getCode());
            baseDownLoadResponse.setMessage(responseDTO.getMessage());
            return baseDownLoadResponse;
        }
        BaseDownLoadResponse<T> result = new BaseDownLoadResponse<>();
        result.setCode(responseDTO.getCode());
        result.setMessage(responseDTO.getMessage());
        result.setResult(responseDTO.getResult());
        result.setVer(responseDTO.getVer());
        result.setScrollId(responseDTO.getScrollId());
        result.setTotalNum(responseDTO.getTotalNum());
        return result;
    }

    private <T> BaseRequest<T> createBaseRequest(T req, String trackingNo) {
        BaseRequest<T> request = new BaseRequest<>();
        request.setRequestBody(req);
        request.setAppName(orderCenterProperties.getAppName());
        request.setBaseUrl(orderCenterProperties.getBaseUrl());
        request.setTrackingNo(trackingNo);
        return request;
    }
}
