package cn.freemud.entities.dto.order;

import lombok.Data;

/**
 * 订单结算明细 包含所有其他优惠信息
 */
@Data
public class OrderAccountDto {
    /**
     * 订单id
     */
    private String orderId;
    /**
     * 活动id
     */
    private String accountId;
    /**
     * 活动名称
     */
    private String name;
    /**
     * 活动类型 ActivityTypeEnum
     */
    private Integer type;
    /**
     * 结算价格 包装费，配送费为正数 ，优惠券，限时特价，满减为负数
     */
    private Long price;
    /**
     * 排序
     */
    private Integer sequence;
    /**
     * 自定义字段
     */
    private String addInfo;
}
