package com.freemud.application.sdk.api.ordercenter.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: AfterSalesType
 * @Package com.freemud.application.sdk.api.ordercenter.enums
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/11 23:17
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum AfterSalesType {

    OTHER(1, "其他取消"),
    USER_CANCEL(2, "用户取消"),
    PARTNER_CANCEL(3, "商户取消"),
    UNPAID_TIME_OUT_CANCEL(4, "未支付超时关单"),
    ACCEPT_TIME_OUT_CANCEL(5, "商户接单超时取消"),
    PARTNER_REJECT(6, "商家拒单"),
    USER_REJECT(7, "配送用户拒收"),
    USER_SALE_RETURN(8, "用户售后退货/售后退款"),
    SYSTEM_CANCEL(9, "系统取消"),
    CUSTOMER_SERVICE_CANCEL(10, "客服取消"),
    USER_UNIFY_CANCEL(11, "用户统一取消，相当于USER_CANCEL以及USER_SALE_RETURN包含的场景，内部会根据状态解析成具体类型"),;

    private Integer index;
    private String name;

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    AfterSalesType(Integer index, String name) {
        this.index = index;
        this.name = name;
    }
}
