/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryDeliveryAddress
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/3 19:20
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Data
public class AddDeliveryAddressVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;
    /**
     * 收货地址ID
     */
    private String receiveId;
    /**
     * 收货办公楼
     */
    @NotEmpty(message = "officeName 不能为空")
    private String officeName;
    /**
     * 收货地址
     */
    @NotEmpty(message = "receiveAddress 不能为空")
    private String receiveAddress;
    /**
     * 收货用户名
     */
    @NotEmpty(message = "receiveUsername 不能为空")
    private String receiveUsername;
    /**
     * 收货电话
     */
    @Pattern(regexp="^1[3|4|5|6|7|8|9][0-9]{9}$",message="手机号码格式不正确")
    @NotEmpty(message = "手机号不能为空")
    private String receiveMobile;
    /**
     * 收货人性别 sexType 1 男 2 女 0 未知
     */
    @NotNull(message = "性别不能为空")
    private Integer sex;
    /**
     * 用户收货地址纬度
     */
    @NotEmpty(message = "收货地址维度不能为空")
    private String latitude;
    /**
     * 用户收货地址经度
     */
    @NotEmpty(message = "收货地址经度不能为空")
    private String longitude;
    /**
     * 标签
     */
    private String label;

}
