package cn.freemud.client;

import cn.freemud.entities.dto.GetMenuCategoryInfoDto;
import cn.freemud.entities.dto.GetMenuResponseDto;
import cn.freemud.entities.dto.GetProductInfoDto;
import cn.freemud.entities.dto.ProductInfosDto;
import cn.freemud.service.thirdparty.ProductClient;
import com.google.common.collect.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: StoreItemClientTest
 * @Package cn.freemud.client
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/25 16:46
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class StoreItemClientTest {
    @Autowired
    private ProductClient storeItemClient;

    /**
     * 获取门店特定时间段菜单分类
     */
    @Test
    public void getMenuCategory() {
        GetMenuCategoryInfoDto getMenuCategoryInfoDto = new GetMenuCategoryInfoDto();
        getMenuCategoryInfoDto.setBusinessDate("20180805");
        getMenuCategoryInfoDto.setChannelType("beiguo");
        getMenuCategoryInfoDto.setInfoLevel(2);
        getMenuCategoryInfoDto.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        getMenuCategoryInfoDto.setShopId("1036");
        getMenuCategoryInfoDto.setValid(true);
        GetMenuResponseDto getMenuResponseDto = storeItemClient.getMenuCategory(getMenuCategoryInfoDto);
    }



    /**
     * 获取商品的详细信息
     */
    @Test
    public void listProductInfos() {
        String partnerId = "360bb48b-5316-458a-903e-9a44c7f339b1";
        String shopId = "1036";
        List<String> productIds = Lists.newArrayList();
        productIds.add("108626130583421196");
        productIds.add("107901007203140097");
        GetProductInfoDto getProductInfoDto = new GetProductInfoDto();
        getProductInfoDto.setPartnerId(partnerId);
        getProductInfoDto.setShopId(shopId);
        getProductInfoDto.setProductInfoType(2);
        getProductInfoDto.setProductIds(productIds);
        ProductInfosDto productInfosDto = storeItemClient.listProductInfos(getProductInfoDto);
    }


}
