package cn.freemud.service.impl

import cn.freemud.adapter.OrderAdapter
import cn.freemud.entities.bo.CreateOrderBONew
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto
import cn.freemud.entities.dto.store.StoreMixResponseDto
import cn.freemud.entities.vo.CreateOrderVo
import cn.freemud.handler.MemberBlacklistHandler
import cn.freemud.service.business.impl.OrderBusinessServiceImpl
import com.alibaba.fastjson.JSON
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter
import spock.lang.Specification

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/2/23 17:17
 * @description : 
 */
class OrderAdapterServiceImplTest extends Specification {

    def orderServiceImpl = new OrderServiceImpl()

    def orderAdapter = new OrderAdapter(mcCafePartnerId: ["9999"], cocoPartnerId: ["9999"])

    def itemService = Mock(ItemServiceImpl.class)

    def orderBusinessService = new OrderBusinessServiceImpl()

    def orderSdkAdapter = new OrderSdkAdapter()

    def memberBlacklistHandler = Mock(MemberBlacklistHandler.class)

    void setup() {
        orderServiceImpl.orderAdapter = orderAdapter
        orderServiceImpl.itemService = itemService
        orderBusinessService.orderSdkAdapter = orderSdkAdapter
        orderServiceImpl.orderBusinessService = orderBusinessService
        orderServiceImpl.memberBlacklistHandler = memberBlacklistHandler

    }

    def "测试华莱士订单问题"() {
        given: "参数设置"
        def createOrderBO = new CreateOrderBONew()
        // 接口请求信息
        String createVOStr = "{\"channelType\":\"saas\",\"channel\":1,\"partnerId\":\"2690\",\"appId\":\"wxa1f272347828dae8\",\"version\":\"3.0.16.2\",\"sessionId\":\"c45e150aa83a17d9c036efa6aafba52af199b6d6\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"QAJIALE001\",\"takeMealFlag\":0,\"takeMealTime\":\"\",\"expectTime\":\"\",\"couponCode\":\"\",\"couponCodes\":[],\"tableNumber\":\"\",\"latitude\":31.37482,\"longitude\":121.26621,\"orderRemark\":\"\",\"useCustomerScore\":2,\"buyMemberCard\":null,\"premiumExchangeActivity\":null,\"cardCode\":null,\"cardCodes\":null,\"payChannelType\":1,\"reachStoreType\":4}";
        def createOrderVo = JSON.parseObject(createVOStr, CreateOrderVo.class)
        createOrderBO.setCreateOrderVo(createOrderVo)
        // 登录信息
        def userLoginInfoDto = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"cef46527f632a961af7a84209bdb8fcd0997c936\",\"sessionKey\":\"hZtQ1Usx/NhEUyoyduF+FQ==\",\"session_key\":\"hZtQ1Usx/NhEUyoyduF+FQ==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)
        createOrderBO.setUserLoginInfoDto(userLoginInfoDto)
        //  购物车信息
        def shoppingCartGoodsDto = JSON.parseObject("{\"activityDiscountsDtos\":[],\"isDiscountDelivery\":false,\"originalTotalAmount\":910,\"packageAmount\":0,\"packageAmountCollectType\":1,\"products\":[{\"activityDiscountsDtos\":[],\"cartGoodsUid\":\"450a069d-cebb-4620-8365-5e6c633a1aa3\",\"categoryName\":\"套餐\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[{\"customerCode\":\"gl\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":true,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":40,\"originalProductType\":1,\"parentProductId\":\"251946878491615276\",\"picture\":\"https://picture.sandload.cn/1628587383665.jpg\",\"productType\":6,\"qty\":6,\"skuForeignName\":\"\",\"skuId\":\"215810517496862722\",\"skuName\":\"柚子的果篮\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215810517496862722\",\"spuName\":\"柚子的果篮\",\"stockLimit\":false,\"tax\":0.0,\"unit\":\"\",\"weight\":0.0},{\"customerCode\":\"lizhi\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":true,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":10,\"originalProductType\":1,\"parentProductId\":\"251946878491615276\",\"picture\":\"https://picture.sandload.cn/1628586884766.jpg\",\"productType\":6,\"qty\":4,\"skuForeignName\":\"\",\"skuId\":\"215809970724247591\",\"skuName\":\"柚子的荔枝\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215809970724247591\",\"spuName\":\"柚子的荔枝\",\"stockLimit\":false,\"tax\":0.0,\"unit\":\"\",\"weight\":0.0},{\"customerCode\":\"li\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":true,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":11,\"originalProductType\":1,\"parentProductId\":\"251946878491615276\",\"picture\":\"https://picture.sandload.cn/1628586848599.jpg\",\"productType\":6,\"qty\":2,\"skuForeignName\":\"\",\"skuId\":\"215809930343585821\",\"skuName\":\"柚子的梨\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215809930343585821\",\"spuName\":\"柚子的梨\",\"stockLimit\":false,\"tax\":0.0,\"unit\":\"\",\"weight\":0.0},{\"customerCode\":\"jrb\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":false,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":33,\"originalProductType\":1,\"parentProductId\":\"251946878491615276\",\"picture\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productType\":6,\"qty\":4,\"skuForeignName\":\"\",\"skuId\":\"215806490097850416\",\"skuName\":\"柚子的鸡肉棒\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806490097850416\",\"spuName\":\"柚子的鸡肉棒\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"customerCode\":\"hb\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":false,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":2,\"originalProductType\":1,\"parentProductId\":\"251946878491615276\",\"picture\":\"https://picture.sandload.cn/1628583887266.png\",\"productType\":6,\"qty\":2,\"skuForeignName\":\"\",\"skuId\":\"215806824348227645\",\"skuName\":\"柚子的汉堡\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806824348227645\",\"spuName\":\"柚子的汉堡\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"customerCode\":\"jialetaocan\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isSendGoods\":false,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":168,\"originalProductType\":7,\"picture\":\"https://picture.sandload.cn/1663060775658.jpg\",\"productCode\":\"jialetaocan\",\"productType\":6,\"qty\":2,\"skuForeignName\":\"\",\"skuId\":\"251946878491615276\",\"skuName\":\"迦勒套餐002\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"251946878491615276\",\"spuName\":\"迦勒套餐002\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"activityDiscountsDtos\":[],\"cartGoodsUid\":\"015b7e93-f194-46d5-8503-577a237593f5\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[],\"customerCode\":\"mg\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isSendGoods\":false,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[{\"activityDiscountsDtos\":[],\"customerCode\":\"H00301\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isTableware\":0,\"originalPrice\":11,\"originalProductType\":2,\"qty\":2,\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806159829964858\",\"spuName\":\"加珍珠\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0},{\"activityDiscountsDtos\":[],\"customerCode\":\"H00302\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isTableware\":0,\"originalPrice\":23,\"originalProductType\":2,\"qty\":4,\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806175661365253\",\"spuName\":\"加布丁\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0},{\"activityDiscountsDtos\":[],\"customerCode\":\"H00303\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isTableware\":0,\"originalPrice\":14,\"originalProductType\":2,\"qty\":6,\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806191862913039\",\"spuName\":\"加芋圆\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0},{\"activityDiscountsDtos\":[],\"customerCode\":\"H00304\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isTableware\":0,\"originalPrice\":22,\"originalProductType\":2,\"qty\":8,\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806207417489433\",\"spuName\":\"加椰果\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0}],\"originalPrice\":287,\"originalProductType\":1,\"picture\":\"https://picture.sandload.cn/1628587294259.jpg\",\"productCode\":\"mg\",\"productType\":88,\"qty\":2,\"skuForeignName\":\"\",\"skuId\":\"215810396282525751\",\"skuName\":\"柚子的芒果\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215810396282525751\",\"spuName\":\"柚子的芒果\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"reduceScore\":90,\"scoreReduceAmount\":900,\"totalAmount\":910,\"totalDiscountAmount\":0}"
                , ShoppingCartGoodsDto.class)
        createOrderBO.setShoppingCartGoodsDto(shoppingCartGoodsDto)

        //拓展信息
        def extInfo = new OrderExtInfoDto()
        createOrderBO.setExtInfo(extInfo)

        // 门店信息
        def storeMixResponseDto = JSON.parseObject("{\n" +
                "        \"storeInfo\": {\n" +
                "            \"storeId\": \"32f47616-6e78-42c3-b5ee-768d9983fc69\",\n" +
                "            \"storeCode\": \"229830\",\n" +
                "            \"storeName\": \"华莱士（西平步行街店）\",\n" +
                "            \"storeNameEn\": null,\n" +
                "            \"parentId\": \"16dc665e-8e03-41a8-83ae-95e92666d266\",\n" +
                "            \"parentCode\": \"05Y\",\n" +
                "            \"parentName\": \"湖北（豫）\",\n" +
                "            \"partnerId\": \"2581\",\n" +
                "            \"briefName\": null,\n" +
                "            \"longitude\": \"114.02106387473609\",\n" +
                "            \"latitude\": \"33.383438776512136\",\n" +
                "            \"geohash\": \"wtcjft\",\n" +
                "            \"businessHours\": \"00:00-24:00\",\n" +
                "            \"state\": \"1\",\n" +
                "            \"phone\": \"17719196597\",\n" +
                "            \"address\": \"河南省驻马店市西平县经贸路步行街西段小广场华莱士\",\n" +
                "            \"addressEn\": null,\n" +
                "            \"activeFlag\": 1,\n" +
                "            \"remark\": null,\n" +
                "            \"province\": \"河南省\",\n" +
                "            \"city\": \"驻马店市\",\n" +
                "            \"region\": \"西平县\",\n" +
                "            \"delivery\": \"2\",\n" +
                "            \"deliveryHours\": \"\",\n" +
                "            \"freeDeliveryPrice\": 20.0,\n" +
                "            \"distributionScope\": \"\",\n" +
                "            \"businessHoursDay\": \"00:00-24:00\",\n" +
                "            \"deliveryHoursDay\": null,\n" +
                "            \"storeNotice\": null,\n" +
                "            \"logoUrl\": null,\n" +
                "            \"isBusinessOpen\": \"1\",\n" +
                "            \"businessType\": \"1\",\n" +
                "            \"isSelfMention\": 1,\n" +
                "            \"showDiscount\": null,\n" +
                "            \"thirdPartCode\": \"EA23\",\n" +
                "            \"status\": 1,\n" +
                "            \"deliveryRemark\": null\n" +
                "        },\n" +
                "        \"deliveryInfo\": null,\n" +
                "        \"businessInfo\": {\n" +
                "            \"id\": 203735268043408939,\n" +
                "            \"templateName\": \"【河南】无外卖 无预定单\",\n" +
                "            \"templateType\": 1,\n" +
                "            \"partnerId\": \"2581\",\n" +
                "            \"orderWarnTime\": \"1\",\n" +
                "            \"deliveryOrderWarnTime\": \"1\",\n" +
                "            \"orderPrintConfig\": \"2\",\n" +
                "            \"maxOrderQuantity\": 10000,\n" +
                "            \"isAutoTakeOrder\": 1,\n" +
                "            \"pickupAutomaticOrderTime\": 1,\n" +
                "            \"takeoutAutomaticOrderTime\": 1,\n" +
                "            \"autoChargebackOrderType\": 1,\n" +
                "            \"autoChargebackOrderTime\": 1,\n" +
                "            \"overTimeCloseOrder\": 1,\n" +
                "            \"overTimeCloseOrderTime\": 30,\n" +
                "            \"autoSelfmentionTakeOrderWorkflowFinishTime\": 3,\n" +
                "            \"autoSelfmentionMakerWorkflowFinishTime\": 4,\n" +
                "            \"autoTakeOutTakeOrderWorkflowFinishTime\": 4,\n" +
                "            \"autoDeliveryTakeOrderWorkflowFinishTime\": 3,\n" +
                "            \"appointAutoSelfmentionTakeOrderWorkflowFinishTime\": 4,\n" +
                "            \"appointAutoSelfmentionMakerWorkflowFinishTime\": 4,\n" +
                "            \"appointAutoTakeOutTakeOrderWorkflowFinishTime\": 4,\n" +
                "            \"appointAutoDeliveryTakeOrderWorkflowFinishTime\": 3,\n" +
                "            \"autoThirdDeliveryTakeOrderWorkflowFinishTime\": 5,\n" +
                "            \"appointThirdDeliveryTakeOrderWorkflowFinishTime\": 6,\n" +
                "            \"orderType\": \"pickup\",\n" +
                "            \"invoice\": 0,\n" +
                "            \"deliveryHours\": \"\",\n" +
                "            \"expectedTime\": 0,\n" +
                "            \"takePartInSettleAccounts\": 2,\n" +
                "            \"automaticRefund\": 1,\n" +
                "            \"minPriceForInvoice\": 0,\n" +
                "            \"invoiceExplain\": \"\",\n" +
                "            \"deliveryAppoint\": 0,\n" +
                "            \"deliveryAppointTime\": null,\n" +
                "            \"tableware\": 0,\n" +
                "            \"selfMentionSwitch\": 0,\n" +
                "            \"autoThirdDeliveryPickCompleteWorkflowFinishTime\": 5,\n" +
                "            \"appointThirdDeliveryPickCompleteWorkflowFinishTime\": 5,\n" +
                "            \"timeOfRefund\": \"48\",\n" +
                "            \"timeTypeOfRefund\": 2,\n" +
                "            \"turnOnTimeOfMaking\": 2,\n" +
                "            \"goodsAvgTimeOfMaking\": 5,\n" +
                "            \"deliveryFinishedAfterMinute\": 45,\n" +
                "            \"deliveryProcessingAfterMinute\": 30,\n" +
                "            \"deliveryProcessingBeforeMinute\": 30,\n" +
                "            \"orderProgressBarStatus\": 2,\n" +
                "            \"expandFields\": {\n" +
                "                \"dispatchType\": \"0\",\n" +
                "                \"monthlySalesShow\": \"0\",\n" +
                "                \"progressBarStatus\": 2,\n" +
                "                \"progressBarOrderNumber\": 0,\n" +
                "                \"preOrderSwitch\": \"0\",\n" +
                "                \"pickupPackageFeeSwitch\": \"1\",\n" +
                "                \"dispatchConfig\": [],\n" +
                "                \"deliveryPackageFeeSwitch\": \"1\",\n" +
                "                \"monthlySalesConfigValue\": \"0\",\n" +
                "                \"likesShow\": \"0\",\n" +
                "                \"likesConfigValue\": \"0\",\n" +
                "                \"processBarColorList\": \"\",\n" +
                "                \"scanOrderSwitch\": \"0\",\n" +
                "                \"progressBarProductUnit\": 1,\n" +
                "                \"peakTimeDelivery\": [],\n" +
                "                \"progressBarDetailStatus\": 1,\n" +
                "                \"appendMinutePerKilometer\": \"0\",\n" +
                "                \"progressBarPageList\": \"\"\n" +
                "            },\n" +
                "            \"orgIds\": null,\n" +
                "            \"supportCashierPay\": 2,\n" +
                "            \"processBarResponse\": null\n" +
                "        },\n" +
                "        \"parentUntilTop\": null,\n" +
                "        \"storeImageList\": null,\n" +
                "        \"storeBusyTimeInfoList\": null\n" +
                "    }"
                , StoreMixResponseDto.class)
        createOrderBO.setStoreMixResponseDto(storeMixResponseDto)

        and: "默认值设置"
        memberBlacklistHandler.checkisTrueBlacklist(_) >> null

        when: "调用方法"
        def order = orderServiceImpl.sdkCreateOrder(createOrderBO)

        then: "验证"

    }

}
